"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Metrics = Metrics;
var _react = _interopRequireDefault(require("react"));
var _agent_guards = require("@kbn/elastic-agent-utils/src/agent_guards");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _agent_name = require("../../../../common/agent_name");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _serverless_metrics = require("./serverless_metrics");
var _service_metrics = require("./service_metrics");
var _static_dashboard = require("./static_dashboard");
var _helper = require("./static_dashboard/helper");
var _use_adhoc_apm_data_view = require("../../../hooks/use_adhoc_apm_data_view");
var _jvm_metrics_overview = require("./jvm_metrics_overview");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/metrics/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function Metrics() {
  const {
    agentName,
    runtimeName,
    serverlessType,
    telemetrySdkName,
    telemetrySdkLanguage
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const isAWSLambda = (0, _agent_name.isAWSLambdaAgentName)(serverlessType);
  const {
    dataView
  } = (0, _use_adhoc_apm_data_view.useAdHocApmDataView)();
  const hasDashboardFile = (0, _helper.hasDashboard)({
    agentName,
    telemetrySdkName,
    telemetrySdkLanguage
  });
  if (isAWSLambda) {
    return /*#__PURE__*/_react.default.createElement(_serverless_metrics.ServerlessMetrics, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 12
      }
    });
  }
  if (!hasDashboardFile && !(0, _agent_guards.isElasticAgentName)(agentName !== null && agentName !== void 0 ? agentName : '')) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: _i18n.i18n.translate('xpack.apm.metrics.emptyState.title', {
        defaultMessage: 'Runtime metrics are not available for this Agent / SDK type.'
      }),
      iconType: "info",
      "data-test-subj": "apmMetricsNoDashboardFound",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 7
      }
    });
  }
  if (hasDashboardFile && dataView) {
    return /*#__PURE__*/_react.default.createElement(_static_dashboard.JsonMetricsDashboard, {
      agentName: agentName,
      telemetrySdkName: telemetrySdkName,
      telemetrySdkLanguage: telemetrySdkLanguage,
      runtimeName: runtimeName,
      serverlessType: serverlessType,
      dataView: dataView,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 7
      }
    });
  }
  if (!isAWSLambda && (0, _agent_guards.isJRubyAgentName)(agentName, runtimeName)) {
    return /*#__PURE__*/_react.default.createElement(_jvm_metrics_overview.JvmMetricsOverview, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_service_metrics.ServiceMetrics, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 10
    }
  });
}