"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchParams = void 0;
var _react = require("react");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchParams = () => {
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query: {
      kuery,
      environment,
      rangeFrom,
      rangeTo,
      transactionName,
      transactionType
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  return (0, _react.useMemo)(() => ({
    serviceName,
    transactionName,
    transactionType,
    kuery,
    environment,
    start,
    end
  }), [serviceName, transactionName, transactionType, kuery, environment, start, end]);
};
exports.useFetchParams = useFetchParams;