"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Breadcrumb = void 0;
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_breadcrumb = require("../../../context/breadcrumbs/use_breadcrumb");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Breadcrumb = ({
  title,
  href,
  omitOnServerless = false,
  children,
  parentTitle,
  parentHref
}) => {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  (0, _use_breadcrumb.useBreadcrumb)(() => parentTitle && parentHref ? [{
    title: parentTitle,
    href: core.http.basePath.prepend('/app/apm' + parentHref)
  }, {
    title,
    href: core.http.basePath.prepend('/app/apm' + href)
  }] : {
    title,
    href: core.http.basePath.prepend('/app/apm' + href)
  }, [core.http.basePath, href, parentHref, parentTitle, title], {
    omitOnServerless
  });
  return children;
};
exports.Breadcrumb = Breadcrumb;