"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformResponse = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformResponse = result => ({
  data: result.data.map(entry => {
    var _entry$results;
    return {
      id: entry.id,
      status: entry.status,
      message: entry.message,
      timestamp: entry.timestamp,
      results: (_entry$results = entry.results) === null || _entry$results === void 0 ? void 0 : _entry$results.map(ruleResult => ({
        rule_id: ruleResult.ruleId,
        processed_gaps: ruleResult.processedGaps,
        status: ruleResult.status,
        error: ruleResult.error
      }))
    };
  }),
  total: result.total,
  page: result.page,
  per_page: result.perPage
});
exports.transformResponse = transformResponse;