"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAutoFillSchedulerRoute = void 0;
var _gap_auto_fill_scheduler = require("../../../../../../common/routes/gaps/apis/gap_auto_fill_scheduler");
var _lib = require("../../../../lib");
var _types = require("../../../../../types");
var _transforms = require("./transforms");
var _transform_response = require("../transforms/transform_response");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAutoFillSchedulerRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_ALERTING_GAPS_AUTO_FILL_SCHEDULER_API_PATH}/{id}`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'internal'
    },
    validate: {
      params: _gap_auto_fill_scheduler.getGapAutoFillSchedulerParamsSchemaV1
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForGapAutoFillScheduler();
    const params = req.params;
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const result = await rulesClient.getGapAutoFillScheduler((0, _transforms.transformRequestV1)(params));
    const response = {
      body: (0, _transform_response.transformToGapAutoFillSchedulerResponseBodyV1)(result)
    };
    return res.ok(response);
  })));
};
exports.getAutoFillSchedulerRoute = getAutoFillSchedulerRoute;