"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteAutoFillSchedulerRoute = void 0;
var _lib = require("../../../../lib");
var _types = require("../../../../../types");
var _gap_auto_fill_scheduler = require("../../../../../../common/routes/gaps/apis/gap_auto_fill_scheduler");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteAutoFillSchedulerRoute = (router, licenseState) => {
  router.delete({
    path: `${_types.INTERNAL_ALERTING_GAPS_AUTO_FILL_SCHEDULER_API_PATH}/{id}`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'internal'
    },
    validate: {
      params: _gap_auto_fill_scheduler.getGapAutoFillSchedulerParamsSchemaV1
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForGapAutoFillScheduler();
    const params = req.params;
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    await rulesClient.deleteGapAutoFillScheduler({
      id: params.id
    });
    return res.noContent();
  })));
};
exports.deleteAutoFillSchedulerRoute = deleteAutoFillSchedulerRoute;