"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGapAutoFillSchedulerEventLogger = createGapAutoFillSchedulerEventLogger;
var _plugin = require("../../../plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createGapAutoFillSchedulerEventLogger({
  eventLogger,
  context,
  taskInstance,
  startTime,
  config
}) {
  return ({
    status,
    results = [],
    message
  }) => {
    var _results$map;
    const endTime = new Date();
    const duration = endTime.getTime() - startTime.getTime();
    const ruleIds = new Set();
    results.forEach(result => ruleIds.add(result.ruleId));
    eventLogger.logEvent({
      event: {
        action: _plugin.EVENT_LOG_ACTIONS.gapAutoFillSchedule
      },
      kibana: {
        space_ids: [context.spaceId],
        task: {
          id: taskInstance.id,
          scheduled: taskInstance.scheduledAt.toISOString(),
          schedule_delay: startTime.getTime() - taskInstance.scheduledAt.getTime()
        },
        saved_objects: [{
          rel: 'primary',
          type: 'task',
          id: taskInstance.id
        }],
        gap_auto_fill: {
          execution: {
            status,
            start: startTime.toISOString(),
            end: endTime.toISOString(),
            duration_ms: duration,
            rule_ids: Array.from(ruleIds),
            task_params: {
              name: config.name,
              num_retries: config.numRetries,
              gap_fill_range: config.gapFillRange,
              interval: config.schedule.interval,
              max_backfills: config.maxBackfills
            },
            results: (_results$map = results === null || results === void 0 ? void 0 : results.map(result => ({
              rule_id: result.ruleId,
              processed_gaps: result.processedGaps,
              status: result.status,
              error: result.error
            }))) !== null && _results$map !== void 0 ? _results$map : []
          }
        }
      },
      message
    });
  };
}