"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformMuteUnmuteRequestToRuleAttributes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformMuteUnmuteRequestToRuleAttributes = ({
  paramRules,
  savedRules,
  instanceIdCalculator
}) => {
  return paramRules.map(paramRule => {
    var _savedRule$attributes;
    const savedRule = savedRules.find(rule => rule.id === paramRule.id);
    const newAttributes = instanceIdCalculator({
      existingInstanceIds: (_savedRule$attributes = savedRule === null || savedRule === void 0 ? void 0 : savedRule.attributes.mutedInstanceIds) !== null && _savedRule$attributes !== void 0 ? _savedRule$attributes : [],
      instanceIdsFromRequest: paramRule.alertInstanceIds
    });
    if (!savedRule || !newAttributes) {
      return;
    }
    return {
      id: savedRule.id,
      attributes: newAttributes
    };
  })
  // Removing undefined values for rules that did not change
  .filter(Boolean);
};
exports.transformMuteUnmuteRequestToRuleAttributes = transformMuteUnmuteRequestToRuleAttributes;