"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGapsSummaryByRuleIdsResponseSchema = exports.getGapsSummaryByRuleIdsParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGapsSummaryByRuleIdsParamsSchema = exports.getGapsSummaryByRuleIdsParamsSchema = _configSchema.schema.object({
  start: _configSchema.schema.string(),
  end: _configSchema.schema.string(),
  ruleIds: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    maxSize: 100
  })
});
const getGapsSummaryByRuleIdsResponseSchema = exports.getGapsSummaryByRuleIdsResponseSchema = _configSchema.schema.object({
  data: _configSchema.schema.arrayOf(_configSchema.schema.object({
    ruleId: _configSchema.schema.string(),
    totalUnfilledDurationMs: _configSchema.schema.number(),
    totalInProgressDurationMs: _configSchema.schema.number(),
    totalFilledDurationMs: _configSchema.schema.number(),
    gapFillStatus: _configSchema.schema.maybe(_configSchema.schema.string())
  }))
});