"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.gapAutoFillSchedulerSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  maxBackfills,
  numRetries
} = _constants.gapAutoFillSchedulerLimits;
const gapAutoFillSchedulerSchema = exports.gapAutoFillSchedulerSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  schedule: _configSchema.schema.object({
    interval: _configSchema.schema.string()
  }),
  ruleTypes: _configSchema.schema.arrayOf(_configSchema.schema.object({
    type: _configSchema.schema.string(),
    consumer: _configSchema.schema.string()
  })),
  scope: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  gapFillRange: _configSchema.schema.string(),
  maxBackfills: _configSchema.schema.number(maxBackfills),
  numRetries: _configSchema.schema.number(numRetries),
  createdBy: _configSchema.schema.maybe(_configSchema.schema.string()),
  updatedBy: _configSchema.schema.maybe(_configSchema.schema.string()),
  createdAt: _configSchema.schema.string(),
  updatedAt: _configSchema.schema.string()
});