"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateGapAutoFillSchedulerSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  maxBackfills,
  numRetries
} = _constants.gapAutoFillSchedulerLimits;
const updateGapAutoFillSchedulerSchema = exports.updateGapAutoFillSchedulerSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  gapFillRange: _configSchema.schema.string(),
  maxBackfills: _configSchema.schema.number(maxBackfills),
  numRetries: _configSchema.schema.number(numRetries),
  schedule: _configSchema.schema.object({
    interval: _configSchema.schema.string()
  }),
  scope: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  ruleTypes: _configSchema.schema.arrayOf(_configSchema.schema.object({
    type: _configSchema.schema.string(),
    consumer: _configSchema.schema.string()
  }), {
    minSize: 1
  }),
  request: _configSchema.schema.any()
});