"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEEKDAY_REGEX = exports.ISO_DATE_REGEX = exports.INTERVAL_FREQUENCY_REGEXP = exports.DURATION_REGEX = exports.DEFAULT_TIMEZONE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ISO_DATE_REGEX = exports.ISO_DATE_REGEX = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.\d{3}Z$/;
const WEEKDAY_REGEX = exports.WEEKDAY_REGEX = '^(((\\+|-)[1-5])?(MO|TU|WE|TH|FR|SA|SU))$';
const DURATION_REGEX = exports.DURATION_REGEX = /(\d+)(s|m|h|d)/;
const INTERVAL_FREQUENCY_REGEXP = exports.INTERVAL_FREQUENCY_REGEXP = /(\d+)(d|w|M|y)/;
const DEFAULT_TIMEZONE = exports.DEFAULT_TIMEZONE = 'UTC';