"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAiopsUiActions = registerAiopsUiActions;
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _ui_actions = require("@kbn/ml-ui-actions/src/aiops/ui_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function registerAiopsUiActions(uiActions, coreStart, pluginStart) {
  uiActions.addTriggerActionAsync(_public.ADD_PANEL_TRIGGER, 'create-pattern-analysis-embeddable', async () => {
    const {
      createAddPatternAnalysisEmbeddableAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions')));
    const addPatternAnalysisAction = createAddPatternAnalysisEmbeddableAction(coreStart, pluginStart);
    return addPatternAnalysisAction;
  });
  uiActions.addTriggerActionAsync(_public.ADD_PANEL_TRIGGER, 'create-change-point-chart', async () => {
    const {
      createAddChangePointChartAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions')));
    const addChangePointChartAction = createAddChangePointChartAction(coreStart, pluginStart);
    return addChangePointChartAction;
  });
  uiActions.registerTrigger(_ui_actions.categorizeFieldTrigger);
  uiActions.addTriggerActionAsync(_ui_actions.CATEGORIZE_FIELD_TRIGGER, 'ACTION_CATEGORIZE_FIELD', async () => {
    const {
      createCategorizeFieldAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions')));
    return createCategorizeFieldAction(coreStart, pluginStart);
  });
  uiActions.addTriggerActionAsync(_public2.CONTEXT_MENU_TRIGGER, 'open-change-point-in-ml-app', async () => {
    const {
      createOpenChangePointInMlAppAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions')));
    const openChangePointInMlAppAction = createOpenChangePointInMlAppAction(coreStart, pluginStart);
    return openChangePointInMlAppAction;
  });
  uiActions.addTriggerActionAsync(_public.ADD_PANEL_TRIGGER, 'create-log-rate-analysis-embeddable', async () => {
    const {
      createAddLogRateAnalysisEmbeddableAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions')));
    const addLogRateAnalysisAction = createAddLogRateAnalysisEmbeddableAction(coreStart, pluginStart);
    return addLogRateAnalysisAction;
  });
}