"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAttachmentUiDefinitions = void 0;
var _i18n = require("@kbn/i18n");
var _attachments = require("@kbn/onechat-common/attachments");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerAttachmentUiDefinitions = ({
  attachments
}) => {
  attachments.addAttachmentType(_attachments.AttachmentType.text, {
    getLabel: () => _i18n.i18n.translate('xpack.agentBuilderPlatform.attachments.text.label', {
      defaultMessage: 'Text'
    }),
    getIcon: () => 'document'
  });
  attachments.addAttachmentType(_attachments.AttachmentType.screenContext, {
    getLabel: () => _i18n.i18n.translate('xpack.agentBuilderPlatform.attachments.screenContext.label', {
      defaultMessage: 'Screen context'
    }),
    getIcon: () => 'inspect'
  });
  attachments.addAttachmentType(_attachments.AttachmentType.esql, {
    getLabel: () => _i18n.i18n.translate('xpack.agentBuilderPlatform.attachments.esql.label', {
      defaultMessage: 'ES|QL query'
    }),
    getIcon: () => 'editorCodeBlock'
  });
};
exports.registerAttachmentUiDefinitions = registerAttachmentUiDefinitions;