"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorRoute = void 0;
var _get = require("../../../../common/routes/connector/apis/get");
var _response = require("../../../../common/routes/connector/response");
var _common_transforms = require("../common_transforms");
var _common = require("../../../../common");
var _verify_access_and_context = require("../../verify_access_and_context");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConnectorRoute = (router, licenseState) => {
  router.get({
    path: `${_common.BASE_ACTION_API_PATH}/connector/{id}`,
    security: _constants.DEFAULT_ACTION_ROUTE_SECURITY,
    options: {
      access: 'public',
      summary: `Get connector information`,
      tags: ['oas-tag:connectors']
    },
    validate: {
      request: {
        params: _get.getConnectorParamsSchemaV1
      },
      response: {
        200: {
          body: () => _response.connectorResponseSchemaV1,
          description: 'Indicates a successful call.'
        },
        403: {
          description: 'Indicates that this call is forbidden.'
        }
      }
    }
  }, router.handleLegacyErrors((0, _verify_access_and_context.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const actionsClient = (await context.actions).getActionsClient();
    const {
      id
    } = req.params;
    return res.ok({
      body: (0, _common_transforms.transformConnectorResponseV1)(await actionsClient.get({
        id
      }))
    });
  })));
};
exports.getConnectorRoute = getConnectorRoute;