"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCustomAgents = getCustomAgents;
var _actionsUtils = require("@kbn/actions-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Create http and https proxy agents with custom proxy /hosts/SSL settings from configurationUtilities
 */

function getCustomAgents(configurationUtilities, logger, url, sslOverrides) {
  const generalSSLSettings = configurationUtilities.getSSLSettings();
  const proxySettings = configurationUtilities.getProxySettings();
  const customHostSettings = configurationUtilities.getCustomHostSettings(url);
  return (0, _actionsUtils.getCustomAgents)({
    customHostSettings,
    logger,
    proxySettings,
    sslOverrides,
    sslSettings: generalSSLSettings,
    url
  });
}