"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Plugin {
  constructor(ctx) {
    var _config$email, _config$email2, _config$email2$servic, _config$webhook$ssl$p, _config$webhook;
    (0, _defineProperty2.default)(this, "allowedEmailDomains", null);
    (0, _defineProperty2.default)(this, "enabledEmailServices", void 0);
    (0, _defineProperty2.default)(this, "webhookSslWithPfxEnabled", void 0);
    const config = ctx.config.get();
    this.allowedEmailDomains = ((_config$email = config.email) === null || _config$email === void 0 ? void 0 : _config$email.domain_allowlist) || null;
    this.enabledEmailServices = Array.from(new Set(((_config$email2 = config.email) === null || _config$email2 === void 0 ? void 0 : (_config$email2$servic = _config$email2.services) === null || _config$email2$servic === void 0 ? void 0 : _config$email2$servic.enabled) || ['*']));
    this.webhookSslWithPfxEnabled = (_config$webhook$ssl$p = (_config$webhook = config.webhook) === null || _config$webhook === void 0 ? void 0 : _config$webhook.ssl.pfx.enabled) !== null && _config$webhook$ssl$p !== void 0 ? _config$webhook$ssl$p : true;
  }
  setup() {
    return {
      validateEmailAddresses: (emails, options) => (0, _common.validateEmailAddresses)(this.allowedEmailDomains, emails, options),
      enabledEmailServices: this.enabledEmailServices,
      isWebhookSslWithPfxEnabled: this.webhookSslWithPfxEnabled
    };
  }
  start() {}
}
exports.Plugin = Plugin;