"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveBindingPreDestroy = resolveBindingPreDestroy;
const common_1 = require("@inversifyjs/common");
const BindingType_1 = require("../../binding/models/BindingType");
const CACHE_KEY_TYPE = 'cache';
function resolveBindingPreDestroy(params, binding) {
    if (binding.type === BindingType_1.bindingTypeValues.Instance) {
        const classMetadata = params.getClassMetadata(binding.implementationType);
        const instance = binding.cache
            .value;
        if ((0, common_1.isPromise)(instance)) {
            return instance.then((instance) => resolveInstancePreDestroy(classMetadata, instance));
        }
        else {
            return resolveInstancePreDestroy(classMetadata, instance);
        }
    }
}
function resolveInstancePreDestroy(classMetadata, instance) {
    if (classMetadata.lifecycle.preDestroyMethodName !== undefined &&
        typeof instance[classMetadata.lifecycle.preDestroyMethodName] === 'function') {
        return instance[classMetadata.lifecycle.preDestroyMethodName]();
    }
}
//# sourceMappingURL=resolveBindingPreDestroy.js.map