"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const vitest_1 = require("vitest");
// eslint-disable-next-line vitest/prefer-describe-function-title
(0, vitest_1.describe)('BindToFluentSyntax', () => {
    let bindToFluentSyntaxMock;
    (0, vitest_1.beforeAll)(() => {
        bindToFluentSyntaxMock = {
            toResolvedValue: vitest_1.vitest.fn(),
        };
    });
    (0, vitest_1.describe)('.toResolvedValue', () => {
        (0, vitest_1.describe)('having a factory with a fixed number of primitive arguments', () => {
            let factoryFixture;
            (0, vitest_1.beforeAll)(() => {
                factoryFixture = (arg1, arg2) => {
                    return { arg1, arg2 };
                };
            });
            (0, vitest_1.it)('when called, with no inject options, should throw a syntax error', () => {
                // @ts-expect-error :: Inject options are required
                (0, vitest_1.assertType)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture));
            });
            (0, vitest_1.it)('when called, with less right inject options than function parameters, should throw a syntax error', () => {
                const firstServiceIdentifier = Symbol();
                (0, vitest_1.assertType)(
                // @ts-expect-error :: Too few inject options are provided
                bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    firstServiceIdentifier,
                ]));
            });
            (0, vitest_1.it)('when called, with as many right service identifier inject options as function parameters, should not throw a syntax error', () => {
                const firstServiceIdentifier = Symbol();
                const secondServiceIdentifier = Symbol();
                (0, vitest_1.expectTypeOf)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    firstServiceIdentifier,
                    secondServiceIdentifier,
                ])).toEqualTypeOf();
            });
            (0, vitest_1.it)('when called, with as many "wrong" service identifier inject options as function parameters, should throw a syntax error', () => {
                const firstServiceIdentifier = Symbol();
                const secondServiceIdentifier = Object;
                (0, vitest_1.expectTypeOf)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    firstServiceIdentifier,
                    secondServiceIdentifier,
                ])).toEqualTypeOf();
            });
            (0, vitest_1.it)('when called, with more right service identifier inject options than function parameters, should throw a syntax error', () => {
                const firstServiceIdentifier = Symbol();
                const secondServiceIdentifier = Symbol();
                const thirdServiceIdentifier = Symbol();
                (0, vitest_1.assertType)(
                // @ts-expect-error :: Too many inject options are provided
                bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    firstServiceIdentifier,
                    secondServiceIdentifier,
                    thirdServiceIdentifier,
                ]));
            });
            (0, vitest_1.it)('when called, with as many "wrong" resolve value inject options as function parameters, should not throw a syntax error', () => {
                const firstServiceIdentifier = {
                    // @ts-expect-error :: Unexpected isMultiple property
                    isMultiple: true,
                    serviceIdentifier: Symbol(),
                };
                const secondServiceIdentifier = {
                    // @ts-expect-error :: Unexpected optional property
                    optional: true,
                    serviceIdentifier: Symbol(),
                };
                const thirdServiceIdentifier = {
                    // @ts-expect-error :: Unexpected isMultiple property
                    isMultiple: true,
                    // The compiler is not currently failing due to the isMultiple related error
                    optional: true,
                    serviceIdentifier: Symbol(),
                };
                const fourthServiceIdentifier = {
                    serviceIdentifier: Symbol(),
                };
                (0, vitest_1.assertType)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    firstServiceIdentifier,
                    secondServiceIdentifier,
                ]));
                (0, vitest_1.assertType)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    thirdServiceIdentifier,
                    fourthServiceIdentifier,
                ]));
            });
        });
        (0, vitest_1.describe)('having a factory with an array argument', () => {
            let factoryFixture;
            (0, vitest_1.beforeAll)(() => {
                factoryFixture = (arg1) => arg1;
            });
            (0, vitest_1.it)('when called, with as many "wrong" resolve value inject options as function parameters, should not throw a syntax error', () => {
                const firstServiceIdentifier = {
                    isMultiple: true,
                    serviceIdentifier: Symbol(),
                };
                const secondServiceIdentifier = {
                    // @ts-expect-error :: Unexpected optional inject option
                    optional: true,
                    serviceIdentifier: Symbol(),
                };
                const thirdServiceIdentifier = {
                    isMultiple: true,
                    // @ts-expect-error :: Unexpected optional inject option
                    optional: true,
                    serviceIdentifier: Symbol(),
                };
                // @ts-expect-error :: Expected isMultiple inject option
                const fourthServiceIdentifier = {
                    serviceIdentifier: Symbol(),
                };
                (0, vitest_1.assertType)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    firstServiceIdentifier,
                ]));
                (0, vitest_1.assertType)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    secondServiceIdentifier,
                ]));
                (0, vitest_1.assertType)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    thirdServiceIdentifier,
                ]));
                (0, vitest_1.assertType)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    fourthServiceIdentifier,
                ]));
            });
        });
        (0, vitest_1.describe)('having a factory with an optional argument', () => {
            let factoryFixture;
            (0, vitest_1.beforeAll)(() => {
                factoryFixture = (arg1) => arg1;
            });
            (0, vitest_1.it)('when called, with as many "wrong" resolve value inject options as function parameters, should not throw a syntax error', () => {
                const firstServiceIdentifier = {
                    // @ts-expect-error :: Unexpected isMultiple inject option
                    isMultiple: true,
                    serviceIdentifier: Symbol(),
                };
                const secondServiceIdentifier = {
                    optional: true,
                    serviceIdentifier: Symbol(),
                };
                const thirdServiceIdentifier = {
                    // @ts-expect-error :: Unexpected isMultiple inject option
                    isMultiple: true,
                    optional: true,
                    serviceIdentifier: Symbol(),
                };
                const fourthServiceIdentifier = {
                    serviceIdentifier: Symbol(),
                };
                (0, vitest_1.assertType)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    firstServiceIdentifier,
                ]));
                (0, vitest_1.assertType)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    secondServiceIdentifier,
                ]));
                (0, vitest_1.assertType)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    thirdServiceIdentifier,
                ]));
                (0, vitest_1.assertType)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    fourthServiceIdentifier,
                ]));
            });
        });
        (0, vitest_1.describe)('having a factory with an optional array argument', () => {
            let factoryFixture;
            (0, vitest_1.beforeAll)(() => {
                factoryFixture = (arg1) => arg1;
            });
            (0, vitest_1.it)('when called, with as many "wrong" resolve value inject options as function parameters, should not throw a syntax error', () => {
                // @ts-expect-error :: Expected optional inject option
                const firstServiceIdentifier = {
                    isMultiple: true,
                    serviceIdentifier: Symbol(),
                };
                // @ts-expect-error :: Expected isMultiple inject option
                const secondServiceIdentifier = {
                    optional: true,
                    serviceIdentifier: Symbol(),
                };
                const thirdServiceIdentifier = {
                    isMultiple: true,
                    optional: true,
                    serviceIdentifier: Symbol(),
                };
                // @ts-expect-error :: Expected isMultiple and optional inject options
                const fourthServiceIdentifier = {
                    serviceIdentifier: Symbol(),
                };
                (0, vitest_1.assertType)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    firstServiceIdentifier,
                ]));
                (0, vitest_1.assertType)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    secondServiceIdentifier,
                ]));
                (0, vitest_1.assertType)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    thirdServiceIdentifier,
                ]));
                (0, vitest_1.assertType)(bindToFluentSyntaxMock.toResolvedValue(factoryFixture, [
                    fourthServiceIdentifier,
                ]));
            });
        });
    });
});
//# sourceMappingURL=BindingFluentSyntax.spec-d.js.map