"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseRequests = exports.parseRequest = exports.getAPI = exports.loadSchema = exports.splitSource = exports.spec = exports.httpMethods = void 0;
const url_1 = require("url");
const promises_1 = require("fs/promises");
const path_1 = __importDefault(require("path"));
const Router = __importStar(require("find-my-way-ts"));
const isBrowser = typeof window !== "undefined";
exports.httpMethods = ["GET", "POST", "PUT", "DELETE", "HEAD"];
let router = Router.make({
    ignoreTrailingSlash: true,
    maxParamLength: 1000,
});
// split Dev Console source code into individual commands
function splitSource(source) {
    source = source.replace(/^#.*$/gm, "\n"); // remove comments
    source = source.trim();
    const len = source.length;
    const sources = [];
    let index = 0;
    let prev = 0;
    while (index < len) {
        // Beginning of a new command, we should find the method and proceede to the url.
        for (const method of exports.httpMethods) {
            if (source.slice(index, len).startsWith(method)) {
                index += method.length;
                break;
            }
        }
        nextCommand();
        sources.push(source.slice(prev, index).trim());
        prev = index;
    }
    return sources;
    function nextCommand() {
        if (index == len)
            return;
        let brackets = 0;
        // If we found an http method, then we have found a new command.
        for (const method of exports.httpMethods) {
            if (source.slice(index, len).startsWith(method)) {
                return;
            }
        }
        // If we didn't find an http method, we should increment the index.
        // If we find an open curly bracket, we should also find the closing one
        // before to checking for the http method.
        if (source[index] == "{") {
            while (index < len) {
                if (source[index] == "{") {
                    brackets += 1;
                }
                else if (source[index] == "}") {
                    brackets -= 1;
                }
                if (brackets == 0) {
                    break;
                }
                index += 1;
            }
        }
        else {
            index += 1;
        }
        nextCommand();
    }
}
exports.splitSource = splitSource;
// parse a single console command
function parseCommand(source, options) {
    source = source
        // removes comments tags, such as `<1>`
        .replace(/<([\S\s])>/g, "")
        // removes comments, such as `// optional`
        .replace(/\s*\/\/\s.+/g, "")
        // trimp whitespace
        .trim();
    const data = {
        source: source,
        service: "es",
        params: {},
        method: "",
        url: "",
        path: "",
        rawPath: "",
    };
    const len = source.length;
    let index = 0;
    // identify the method
    for (const method of exports.httpMethods) {
        if (source.slice(index, len).startsWith(method)) {
            data.method = method;
            index += method.length;
            break;
        }
    }
    /* istanbul ignore if */
    if (!data.method) {
        if (options?.ignoreErrors) {
            return data;
        }
        throw new Error("Invalid request method");
    }
    // identify the url and query
    skip(" ", "\n");
    const urlStart = index;
    until("{", "\n");
    while (source[index] == "{" && source[index + 1].match(/[a-z]/i)) {
        // this is a placeholder element inside the URL (as used in doc examples),
        // so we continue scanning
        index++;
        until("{", "\n");
    }
    data.url = source.slice(urlStart, index).trim();
    if (data.url.indexOf(":/") >= 0) {
        [data.service, data.url] = data.url.split(":/", 2);
        data.url = "/" + data.url;
    }
    if (data.url[0] != "/") {
        data.url = "/" + data.url;
    }
    data.url = data.url
        // replaces { with %7B (braces in many doc examples are not URIencoded)
        .replace(/{/g, "%7B")
        // replaces } with %7D
        .replace(/}/g, "%7D");
    const parsedUrl = new url_1.URL(`http://localhost${data.url}`);
    data.rawPath =
        parsedUrl.pathname != "/"
            ? parsedUrl.pathname.replace(/\/$/, "")
            : parsedUrl.pathname;
    data.path = decodeURIComponent(data.rawPath);
    if (parsedUrl.search.length) {
        const parsedQuery = new URLSearchParams(parsedUrl.search.slice(1));
        data.query = {};
        for (const [key, value] of parsedQuery) {
            data.query[key] = value || "true";
        }
    }
    // identify the body
    const body = removeTrailingCommas(collapseLiteralStrings(source.slice(index)));
    if (body != "") {
        try {
            // json body
            data.body = JSON.parse(body);
        }
        catch (err) {
            try {
                // ndjson body
                const ndbody = body.split("\n").filter(Boolean);
                data.body = ndbody.map((b) => JSON.parse(b));
            }
            catch (err) {
                if (options?.ignoreErrors) {
                    data.body = body;
                }
                else {
                    throw new Error("body cannot be parsed");
                }
            }
        }
    }
    return data;
    // some commands have three double quotes `"""` in the body
    // this utility removes them and makes the string a valid json
    function collapseLiteralStrings(data) {
        const splitData = data.split('"""');
        for (let idx = 1; idx < splitData.length - 1; idx += 2) {
            splitData[idx] = JSON.stringify(splitData[idx]);
        }
        return splitData.join("");
    }
    // remove any trailing commas to prevent JSON parser failures
    function removeTrailingCommas(data) {
        return data.replace(/,([ |\t|\n]+[}|\]|)])/g, "$1");
    }
    // proceeds until it finds a character not present
    // in the list passed as input
    function skip(...args) {
        if (index == len)
            return;
        if (!args.includes(source[index])) {
            return;
        }
        index += 1;
        skip(...args);
    }
    // proceeds until it finds a character present
    // in the list passed as input
    function until(...args) {
        if (index == len)
            return;
        if (args.includes(source[index])) {
            return;
        }
        index += 1;
        until(...args);
    }
}
/** Load a schema.json file with the Elasticsearch specification.
 *
 * This function is used internally to load the Elasticsearch specification to
 * use to categorize requests. It is normally not necessary to invoke this
 * function directly, but it can be used to load a different version of the
 * specification than the one bundled with this package.
 *
 * @param filename_or_object The path to the schema.json file to load, or an
 *   object with a loaded schema.
 */
async function loadSchema(filename_or_object) {
    if (typeof filename_or_object === "string") {
        exports.spec = JSON.parse(await (0, promises_1.readFile)(filename_or_object, { encoding: "utf-8" }));
    }
    else {
        exports.spec = filename_or_object;
    }
    if (router.find("GET", "/") != undefined) {
        // start from a clean router
        router = Router.make({
            ignoreTrailingSlash: true,
            maxParamLength: 1000,
        });
    }
    for (const endpoint of exports.spec.endpoints) {
        for (const url of endpoint.urls) {
            const { path, methods } = url;
            let formattedPath = path
                .split("/")
                .map((p) => (p.startsWith("{") ? `:${p.slice(1, -1)}` : p))
                .join("/");
            /* istanbul ignore next */
            if (!formattedPath.startsWith("/")) {
                formattedPath = "/" + formattedPath;
            }
            // find the request in the spec
            try {
                let req;
                let mt;
                for (const type of exports.spec.types) {
                    if (type.name.namespace == endpoint.request?.namespace &&
                        type.name.name == endpoint.request?.name) {
                        if (type.kind != "request") {
                            /* istanbul ignore next */
                            throw new Error(`Unexpected request type ${type.kind} for URL ${url}`);
                        }
                        req = type;
                        mt = endpoint.requestMediaType;
                        break;
                    }
                }
                const r = {
                    name: endpoint.name,
                    availability: endpoint.availability,
                    request: req,
                    mediaTypes: mt,
                };
                router.on(methods, formattedPath, r);
            }
            catch (err) {
                // in some cases there are routes that have the same url but different
                // dynamic parameters, which causes find-my-way to fail
            }
        }
    }
}
exports.loadSchema = loadSchema;
// use a router to figure out the API name
async function getAPI(method, endpointPath) {
    if (router.find("GET", "/") == undefined) {
        if (!isBrowser) {
            // load the Elasticsearch spec
            await loadSchema(path_1.default.join(__dirname, "./schema.json"));
        }
        else {
            throw new Error("Specification is missing");
        }
    }
    const formattedPath = endpointPath.startsWith("/")
        ? endpointPath
        : `/${endpointPath}`;
    const route = router.find(method, formattedPath);
    if (!route) {
        /* istanbul ignore next */
        throw new Error(`There is no handler for method '${method}' and url '${formattedPath}'`);
    }
    return route;
}
exports.getAPI = getAPI;
async function parseRequest(source, options) {
    source = source.replace(/^\s+|\s+$/g, ""); // trim whitespace
    const req = parseCommand(source, options ?? {});
    if (req.service == "es") {
        // for Elasticsearch URLs we can get API details
        try {
            const route = await getAPI(req.method, req.rawPath);
            req.api = route.handler.name;
            req.availability = route.handler.availability;
            req.request = route.handler.request;
            req.mediaTypes = route.handler.mediaTypes;
            if (Object.keys(route.params).length > 0) {
                req.params = route.params;
            }
        }
        catch (error) {
            if (!options?.ignoreErrors) {
                throw error;
            }
        }
    }
    return req;
}
exports.parseRequest = parseRequest;
/** Parse a Dev Console script.
 *
 * This function is used internally by the `convertRequests()` function, so in
 * general it does not need to be called directly.
 *
 * @param source The source code to parse in Dev Console syntax. Multiple requests
 *   can be separated with an empty line.
 * @returns The function returns an array of `ParsedRequest` objects, each describing
 *   a request.
 */
async function parseRequests(source, options) {
    const sources = splitSource(source);
    return await Promise.all(sources.map((source) => parseRequest(source, options)));
}
exports.parseRequests = parseRequests;
