"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTreeViewClass = exports.EuiTreeView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _accessibility = require("../accessibility");
var _tree_view_item = require("./tree_view_item");
var _tree_view = require("./tree_view.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "items", "display", "expandByDefault", "showExpansionArrows", "theme"];
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiTreeViewContext = /*#__PURE__*/(0, _react.createContext)('');
function getTreeId(propId) {
  var contextId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  var idGenerator = arguments.length > 2 ? arguments[2] : undefined;
  return propId !== null && propId !== void 0 ? propId : contextId === '' ? idGenerator() : contextId;
}
var EuiTreeViewClass = exports.EuiTreeViewClass = /*#__PURE__*/function (_Component) {
  function EuiTreeViewClass(props,
  // Without the optional ? typing, TS will throw errors on JSX component errors
  // @see https://github.com/facebook/react/issues/13944#issuecomment-1183693239
  context) {
    var _this;
    _classCallCheck(this, EuiTreeViewClass);
    // TODO: context in constructor has been deprecated.
    // We should likely convert this to a function component
    _this = _callSuper(this, EuiTreeViewClass, [props, context]);
    _defineProperty(_this, "treeIdGenerator", (0, _services.htmlIdGenerator)('euiTreeView'));
    _defineProperty(_this, "isNested", void 0);
    _defineProperty(_this, "buttonRef", []);
    _defineProperty(_this, "setButtonRef", function (ref, index) {
      _this.buttonRef[index] = ref;
    });
    _defineProperty(_this, "handleNodeClick", function (node) {
      var ignoreCallback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var index = _this.state.openItems.indexOf(node.id);
      _this.setState({
        expandChildNodes: false
      });
      node.isExpanded = !node.isExpanded;
      if (!ignoreCallback && node.callback !== undefined) {
        node.callback();
      }
      if (_this.isNodeOpen(node)) {
        // if the node is part of openItems[] then remove it
        _this.setState({
          openItems: _this.state.openItems.filter(function (_, i) {
            return i !== index;
          })
        });
      } else {
        // if the node isn't part of openItems[] then add it
        _this.setState(function (prevState) {
          return {
            openItems: [].concat(_toConsumableArray(prevState.openItems), [node.id]),
            activeItem: node.id
          };
        });
      }
    });
    // check if the node is included in openItems[]
    _defineProperty(_this, "isNodeOpen", function (node) {
      return _this.state.openItems.includes(node.id);
    });
    // Enable keyboard navigation
    _defineProperty(_this, "onKeyDown", function (event, node) {
      switch (event.key) {
        case _services.keys.ARROW_DOWN:
          {
            var nodeButtons = Array.from(document.querySelectorAll("[data-test-subj=\"euiTreeViewButton-".concat(_this.state.treeID, "\"]")));
            var currentIndex = nodeButtons.indexOf(event.currentTarget);
            if (currentIndex > -1) {
              var nextButton = nodeButtons[currentIndex + 1];
              if (nextButton) {
                event.preventDefault();
                event.stopPropagation();
                nextButton.focus();
              }
            }
            break;
          }
        case _services.keys.ARROW_UP:
          {
            var _nodeButtons = Array.from(document.querySelectorAll("[data-test-subj=\"euiTreeViewButton-".concat(_this.state.treeID, "\"]")));
            var _currentIndex = _nodeButtons.indexOf(event.currentTarget);
            if (_currentIndex > -1) {
              var prevButton = _nodeButtons[_currentIndex + -1];
              if (prevButton) {
                event.preventDefault();
                event.stopPropagation();
                prevButton.focus();
              }
            }
            break;
          }
        case _services.keys.ARROW_RIGHT:
          {
            if (!_this.isNodeOpen(node)) {
              event.preventDefault();
              event.stopPropagation();
              _this.handleNodeClick(node, true);
            }
            break;
          }
        case _services.keys.ARROW_LEFT:
          {
            if (_this.isNodeOpen(node)) {
              event.preventDefault();
              event.stopPropagation();
              _this.handleNodeClick(node, true);
            }
          }
        default:
          break;
      }
    });
    _defineProperty(_this, "onChildrenKeydown", function (event, index) {
      if (event.key === _services.keys.ARROW_LEFT) {
        event.preventDefault();
        event.stopPropagation();
        _this.buttonRef[index].focus();
      }
    });
    _this.isNested = !!_this.context;
    _this.state = {
      openItems: _this.props.expandByDefault ? _this.props.items.map(function (_ref) {
        var id = _ref.id,
          children = _ref.children;
        return children ? id : null;
      }).filter(function (x) {
        return x != null;
      }) : _this.props.items.map(function (_ref2) {
        var id = _ref2.id,
          children = _ref2.children,
          isExpanded = _ref2.isExpanded;
        return children && isExpanded ? id : null;
      }).filter(function (x) {
        return x != null;
      }),
      activeItem: '',
      treeID: getTreeId(_this.props.id, context, _this.treeIdGenerator),
      expandChildNodes: _this.props.expandByDefault || false
    };
    return _this;
  }
  _inherits(EuiTreeViewClass, _Component);
  return _createClass(EuiTreeViewClass, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.id !== prevProps.id) {
        this.setState({
          treeID: getTreeId(this.props.id, this.context, this.treeIdGenerator)
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        items = _this$props.items,
        _this$props$display = _this$props.display,
        display = _this$props$display === void 0 ? 'default' : _this$props$display,
        expandByDefault = _this$props.expandByDefault,
        showExpansionArrows = _this$props.showExpansionArrows,
        theme = _this$props.theme,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var styles = (0, _tree_view.euiTreeViewStyles)(theme);
      var cssStyles = [styles.euiTreeView, styles[display]];

      // Computed classNames
      var classes = (0, _classnames.default)('euiTreeView', className);
      var instructionsId = "".concat(this.state.treeID, "--instruction");
      return (0, _react2.jsx)(EuiTreeViewContext.Provider, {
        value: this.state.treeID
      }, !this.isNested && (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiTreeView.listNavigationInstructions",
        default: "You can quickly navigate this list using arrow keys."
      }, function (listNavigationInstructions) {
        return (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", {
          id: instructionsId
        }, listNavigationInstructions));
      }), (0, _react2.jsx)("ul", _extends({
        css: cssStyles,
        className: classes,
        id: !this.isNested ? this.state.treeID : undefined,
        "aria-describedby": !this.isNested ? instructionsId : undefined,
        role: "list" // VoiceOver doesn't parse lists with `list-style: none` as the correct role - @see https://www.scottohara.me/blog/2019/01/12/lists-and-safari.html
      }, rest), items.map(function (node, index) {
        var buttonId = node.id;
        var wrappingId = _this2.treeIdGenerator(buttonId);
        var isNodeExpanded = node.children ? _this2.isNodeOpen(node) : undefined; // Determines the `aria-expanded` attribute

        var icon = node.icon;
        if (node.iconWhenExpanded && isNodeExpanded) {
          icon = node.iconWhenExpanded;
        } else if (!icon && node.useEmptyIcon) {
          icon = (0, _react2.jsx)(_react.default.Fragment, null); // Renders a placeholder
        }
        return (0, _react2.jsx)(_tree_view_item.EuiTreeViewItem, {
          key: buttonId + index,
          id: buttonId,
          className: node.className,
          css: node.css,
          buttonRef: function buttonRef(ref) {
            return _this2.setButtonRef(ref, index);
          },
          "aria-controls": node.children ? wrappingId : undefined,
          label: node.label,
          icon: icon,
          hasArrow: showExpansionArrows,
          isExpanded: isNodeExpanded,
          isActive: _this2.state.activeItem === node.id,
          display: display,
          "data-test-subj": "euiTreeViewButton-".concat(_this2.state.treeID),
          onKeyDown: function onKeyDown(event) {
            return _this2.onKeyDown(event, node);
          },
          onClick: function onClick() {
            return _this2.handleNodeClick(node);
          }
        }, node.children && (0, _react2.jsx)("div", {
          id: wrappingId,
          onKeyDown: function onKeyDown(event) {
            return _this2.onChildrenKeydown(event, index);
          }
        }, isNodeExpanded && (0, _react2.jsx)(EuiTreeView, {
          items: node.children,
          display: display,
          showExpansionArrows: showExpansionArrows,
          expandByDefault: _this2.state.expandChildNodes
        })));
      })));
    }
  }]);
}(_react.Component);
_defineProperty(EuiTreeViewClass, "contextType", EuiTreeViewContext);
EuiTreeViewClass.propTypes = {
  className: _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * An array of EuiTreeViewNodes
       */
  items: _propTypes.default.arrayOf(_propTypes.default.shape({
    /** An array of EuiTreeViewNodes to render as children
       */
    children: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
    /** The readable label for the item
       */
    label: _propTypes.default.node.isRequired,
    /** A unique ID
       */
    id: _propTypes.default.string.isRequired,
    /** An icon to use on the left of the label
       */
    icon: _propTypes.default.element,
    /** Display a different icon when the item is expanded.
      For instance, an open folder or a down arrow
      */
    iconWhenExpanded: _propTypes.default.element,
    /** Use an empty icon to keep items without an icon
      lined up with their siblings
      */
    useEmptyIcon: _propTypes.default.bool,
    /** Whether or not the item is expanded.
       */
    isExpanded: _propTypes.default.bool,
    /** Optional class to throw on the node
       */
    className: _propTypes.default.string,
    /** Optional styles
       */
    css: _propTypes.default.any,
    /** Function to call when the item is clicked.
       The open state of the item will always be toggled.
       */
    callback: _propTypes.default.func
  }).isRequired).isRequired,
  /**
       * Optionally use a variation with smaller text and icon sizes
       * @default default
       */
  display: _propTypes.default.oneOf(["default", "compressed"]),
  /**
       * Set all items to open on initial load
       */
  expandByDefault: _propTypes.default.bool,
  /**
       * Display expansion arrows next to all items
       * that contain children
       */
  showExpansionArrows: _propTypes.default.bool,
  "aria-label": _propTypes.default.string,
  "aria-labelledby": _propTypes.default.string
};
var EuiTreeView = exports.EuiTreeView = Object.assign((0, _services.withEuiTheme)(EuiTreeViewClass), {
  Item: _tree_view_item.EuiTreeViewItem
});