"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LINES = exports.EuiSkeletonText = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _skeleton_loading = require("./skeleton_loading");
var _skeleton_text = require("./skeleton_text.styles");
var _react2 = require("@emotion/react");
var _excluded = ["isLoading", "lines", "size", "className", "contentAriaLabel", "announceLoadingStatus", "announceLoadedStatus", "ariaLiveProps", "ariaWrapperProps", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var LINES = exports.LINES = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
var EuiSkeletonText = exports.EuiSkeletonText = function EuiSkeletonText(_ref) {
  var _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? true : _ref$isLoading,
    _ref$lines = _ref.lines,
    lines = _ref$lines === void 0 ? 3 : _ref$lines,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    className = _ref.className,
    contentAriaLabel = _ref.contentAriaLabel,
    announceLoadingStatus = _ref.announceLoadingStatus,
    announceLoadedStatus = _ref.announceLoadedStatus,
    ariaLiveProps = _ref.ariaLiveProps,
    ariaWrapperProps = _ref.ariaWrapperProps,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_skeleton_text.euiSkeletonTextStyles);
  var cssStyles = (0, _react.useMemo)(function () {
    return [styles.euiSkeletonText, styles[size]];
  }, [styles, size]);
  var lineElements = (0, _react.useMemo)(function () {
    var lineElements = [];
    for (var i = 0; i < lines; i++) {
      lineElements.push((0, _react2.jsx)("span", {
        key: i,
        css: cssStyles
      }));
    }
    return lineElements;
  }, [lines, cssStyles]);
  return (0, _react2.jsx)(_skeleton_loading.EuiSkeletonLoading, _extends({
    isLoading: isLoading,
    loadingContent: (0, _react2.jsx)("span", _extends({
      className: (0, _classnames.default)('euiSkeletonText', className)
    }, rest), lineElements),
    loadedContent: children || '',
    contentAriaLabel: contentAriaLabel,
    announceLoadingStatus: announceLoadingStatus,
    announceLoadedStatus: announceLoadedStatus,
    ariaLiveProps: ariaLiveProps
  }, ariaWrapperProps));
};
EuiSkeletonText.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * When true, shows the loading skeleton component.
     * When false, shows any `children` and announces to screen readers that your content has loaded.
     */
  isLoading: _propTypes.default.bool,
  /**
     * Label your loading sections to provide more helpful context to screen readers.
     * For example, pass "API keys" to have screen readers read "Loading API keys" and "Loaded API keys".
     */
  contentAriaLabel: _propTypes.default.string,
  /**
     * Makes a live screen reader announcement when `isLoading` is true
     * @default false
     */
  announceLoadingStatus: _propTypes.default.bool,
  /**
     * Makes a live screen reader announcement when `isLoading` is false
     * @default true
     */
  announceLoadedStatus: _propTypes.default.bool,
  /**
     * Optional props to pass to the `aria-live` region that announces the loading status to screen readers.
     * Accepts any `EuiScreenReaderLive` props.
     */
  ariaLiveProps: _propTypes.default.any,
  /**
     * Optional props to pass to the `aria-busy` wrapper around the skeleton content
     */
  ariaWrapperProps: _propTypes.default.any,
  /**
       * Number of lines to display (between 1 to 10)
       */
  lines: _propTypes.default.any,
  /**
       * EuiText size to render
       */
  size: _propTypes.default.any
};