"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiHeaderVariables = exports.euiHeaderStyles = void 0;
var _react = require("@emotion/react");
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _global_styling = require("../../global_styling");
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiHeaderVariables = exports.euiHeaderVariables = function euiHeaderVariables(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    height: euiTheme.size.xxxl,
    childHeight: euiTheme.size.xxl,
    padding: euiTheme.size.s
  };
};
var euiHeaderStyles = exports.euiHeaderStyles = function euiHeaderStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiHeaderVariables = euiHeaderVariables(euiThemeContext),
    height = _euiHeaderVariables.height,
    padding = _euiHeaderVariables.padding;
  return {
    euiHeader: /*#__PURE__*/(0, _react.css)("display:flex;justify-content:space-between;", (0, _global_styling.logicalCSS)('height', height), " ", (0, _global_styling.logicalCSS)('padding-horizontal', padding), " ", (0, _global_styling.logicalCSS)('border-bottom', euiTheme.border.thin), " ", (0, _euiThemeCommon.euiShadowXSmall)(euiThemeContext, {
      border: 'none'
    }), "&+.euiHeader{clip-path:polygon(0 0, 100% 0, 100% 100vh, 0 100vh);};label:euiHeader;"),
    // Position
    static: /*#__PURE__*/(0, _react.css)("z-index:", Number(euiTheme.levels.header) - 1, ";position:relative;;label:static;"),
    fixed: /*#__PURE__*/(0, _react.css)("z-index:", Number(euiTheme.levels.header) + 1, ";position:fixed;", (0, _global_styling.logicalCSS)('top', 0), " ", (0, _global_styling.logicalCSS)('horizontal', 0), ";;label:fixed;"),
    // Theme
    default: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.components.headerBackground, ";;label:default;"),
    dark: /*#__PURE__*/(0, _react.css)(euiHeaderDarkStyles(euiThemeContext), ";label:dark;")
  };
};

/**
 * The `dark` header is (currently) a bit of a special case. We don't
 * actually want to use <EuiThemeProvider colorMode="dark"> inside it
 * because that will affect popovers and `SelectableSitewideTemplate`
 * as well, which we do not necessarily want to do (?)
 *
 * It's also possible that the dark header will go away or become unused
 * by Kibana in the near future, at which point we can remove this
 */

var euiHeaderDarkStyles = function euiHeaderDarkStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var backgroundColor = euiTheme.components.headerDarkBackground;
  return "\n    background-color: ".concat(backgroundColor, ";\n\n    .euiHeaderLogo__text,\n    .euiHeaderLink,\n    .euiHeaderSectionItemButton {\n      color: ").concat(euiTheme.colors.ghost, ";\n    }\n\n    .euiHeaderLink-isActive {\n      color: ").concat((0, _services.makeHighContrastColor)(euiTheme.colors.primary)(backgroundColor), ";\n    }\n\n    .euiHeaderLogo,\n    .euiHeaderLink,\n    .euiHeaderSectionItemButton {\n      &:focus {\n        background-color: ").concat(euiTheme.components.headerDarkSectionItemBackgroundFocus, ";\n      }\n    }\n\n    .euiHeaderSectionItemButton__notification--badge {\n      box-shadow: 0 0 0 ").concat(euiTheme.border.width.thin, " ").concat(backgroundColor, ";\n    }\n\n    .euiHeaderSectionItemButton__notification--dot {\n      stroke: ").concat(backgroundColor, ";\n    }\n  ");
};