"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSuperSelectItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _context_menu = require("../../context_menu");
var _super_select = require("./super_select.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "hasDividers"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Type exposed to consumers via API
// Actual props used by below component, transmogged by parent EuiSuperSelect
// from consumer props to internal EUI props
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
// Internal subcomponent util, primarily for easier usage of hooks
var EuiSuperSelectItem = exports.EuiSuperSelectItem = function EuiSuperSelectItem(_ref) {
  var children = _ref.children,
    className = _ref.className,
    hasDividers = _ref.hasDividers,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiSuperSelect__item', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_super_select.euiSuperSelectItemStyles);
  var cssStyles = [styles.euiSuperSelect__item, hasDividers && styles.hasDividers];
  return (0, _react2.jsx)(_context_menu.EuiContextMenuItem, _extends({
    css: cssStyles,
    className: classes,
    role: "option"
  }, rest), children);
};
EuiSuperSelectItem.propTypes = {
  hasDividers: _propTypes.default.bool
};