"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiFlyoutResizable = void 0;
var _react = require("react");
var _services = require("../../services");
var _helpers = require("../resizable_container/helpers");
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * @internal
 */
var useEuiFlyoutResizable = exports.useEuiFlyoutResizable = function useEuiFlyoutResizable(_ref) {
  var enabled = _ref.enabled,
    _ref$minWidth = _ref.minWidth,
    minWidth = _ref$minWidth === void 0 ? 0 : _ref$minWidth,
    maxWidth = _ref.maxWidth,
    onResize = _ref.onResize,
    side = _ref.side,
    _size = _ref.size;
  var getFlyoutMinMaxWidth = (0, _react.useCallback)(function (width) {
    return Math.min(Math.max(width, minWidth), maxWidth || Infinity, window.innerWidth - 20 // Leave some offset
    );
  }, [minWidth, maxWidth]);
  var _useState = (0, _react.useState)(0),
    _useState2 = _slicedToArray(_useState, 2),
    flyoutWidth = _useState2[0],
    setFlyoutWidth = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    callOnResize = _useState4[0],
    setCallOnResize = _useState4[1];

  // Must use state for the flyout ref in order for the useEffect to be correctly called after render
  var _useState5 = (0, _react.useState)(null),
    _useState6 = _slicedToArray(_useState5, 2),
    flyoutRef = _useState6[0],
    setFlyoutRef = _useState6[1];
  (0, _react.useEffect)(function () {
    if (!enabled) return; // Don't measure when resizing is disabled
    if (!flyoutWidth && flyoutRef) {
      setCallOnResize(false); // Don't call `onResize` for non-user width changes
      setFlyoutWidth(getFlyoutMinMaxWidth(flyoutRef.offsetWidth));
    }
  }, [flyoutWidth, flyoutRef, getFlyoutMinMaxWidth, enabled]);

  // Update flyout width when consumers pass in a new `size`
  (0, _react.useEffect)(function () {
    if (!enabled) return; // Don't update width when resizing is disabled
    setCallOnResize(false);
    // For string `size`s, resetting flyoutWidth to 0 will trigger the above useEffect's recalculation
    setFlyoutWidth(typeof _size === 'number' ? getFlyoutMinMaxWidth(_size) : 0);
  }, [_size, getFlyoutMinMaxWidth, enabled]);

  // Initial numbers to calculate from, on resize drag start
  var initialWidth = (0, _react.useRef)(0);
  var initialMouseX = (0, _react.useRef)(0);

  // Account for flyout side and logical property direction
  var direction = (0, _react.useMemo)(function () {
    var modifier = side === 'right' ? -1 : 1;
    if (flyoutRef) {
      var languageDirection = window.getComputedStyle(flyoutRef).direction;
      if (languageDirection === 'rtl') modifier *= -1;
    }
    return modifier;
  }, [side, flyoutRef]);
  var onMouseMove = (0, _react.useCallback)(function (e) {
    if (!enabled) {
      return;
    }
    var mouseOffset = (0, _helpers.getPosition)(e, true) - initialMouseX.current;
    var changedFlyoutWidth = initialWidth.current + mouseOffset * direction;
    setFlyoutWidth(getFlyoutMinMaxWidth(changedFlyoutWidth));
  }, [getFlyoutMinMaxWidth, direction, enabled]);
  var onMouseUp = (0, _react.useCallback)(function () {
    setCallOnResize(true);
    if (!enabled) {
      return;
    }
    initialMouseX.current = 0;
    window.removeEventListener('mousemove', onMouseMove);
    window.removeEventListener('mouseup', onMouseUp);
    window.removeEventListener('touchmove', onMouseMove);
    window.removeEventListener('touchend', onMouseUp);
  }, [onMouseMove, enabled]);
  var onMouseDown = (0, _react.useCallback)(function (e) {
    var _flyoutRef$offsetWidt;
    setCallOnResize(false);
    if (!enabled) {
      return;
    }
    initialMouseX.current = (0, _helpers.getPosition)(e, true);
    initialWidth.current = (_flyoutRef$offsetWidt = flyoutRef === null || flyoutRef === void 0 ? void 0 : flyoutRef.offsetWidth) !== null && _flyoutRef$offsetWidt !== void 0 ? _flyoutRef$offsetWidt : 0;

    // Window event listeners instead of React events are used
    // in case the user's mouse leaves the component
    window.addEventListener('mousemove', onMouseMove);
    window.addEventListener('mouseup', onMouseUp);
    window.addEventListener('touchmove', onMouseMove);
    window.addEventListener('touchend', onMouseUp);
  }, [flyoutRef, onMouseMove, onMouseUp, enabled]);
  var onKeyDown = (0, _react.useCallback)(function (e) {
    setCallOnResize(true);
    if (!enabled) {
      return;
    }
    var KEYBOARD_OFFSET = 10;
    switch (e.key) {
      case _services.keys.ARROW_RIGHT:
        e.preventDefault(); // Safari+VO will screen reader navigate off the button otherwise
        setFlyoutWidth(function (flyoutWidth) {
          return getFlyoutMinMaxWidth(flyoutWidth + KEYBOARD_OFFSET * direction);
        });
        break;
      case _services.keys.ARROW_LEFT:
        e.preventDefault(); // Safari+VO will screen reader navigate off the button otherwise
        setFlyoutWidth(function (flyoutWidth) {
          return getFlyoutMinMaxWidth(flyoutWidth - KEYBOARD_OFFSET * direction);
        });
    }
  }, [getFlyoutMinMaxWidth, direction, enabled]);

  // To reduce unnecessary calls, only fire onResize callback:
  // 1. After initial mount / on user width change events only
  // 2. If not currently mouse dragging
  (0, _react.useEffect)(function () {
    if (callOnResize && enabled) {
      onResize === null || onResize === void 0 || onResize(flyoutWidth);
    }
  }, [onResize, callOnResize, flyoutWidth, enabled]);
  var size = (0, _react.useMemo)(function () {
    return enabled ? flyoutWidth || _size : _size;
  }, [enabled, flyoutWidth, _size]);
  return {
    onKeyDown: onKeyDown,
    onMouseDown: onMouseDown,
    setFlyoutRef: setFlyoutRef,
    size: size
  };
};