"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.maxedFlyoutWidth = exports.euiFlyoutStyles = exports.euiFlyoutSlideOutRight = exports.euiFlyoutSlideOutLeft = exports.euiFlyoutSlideInRight = exports.euiFlyoutSlideInLeft = exports.composeFlyoutSizing = exports.composeFlyoutInlineStyles = exports.FLYOUT_BREAKPOINT = void 0;
var _react = require("@emotion/react");
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _const = require("./const");
var _global_styling = require("../../global_styling");
var _form = require("../form/form.styles");
var _templateObject, _templateObject2, _templateObject3, _templateObject4;
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var FLYOUT_BREAKPOINT = exports.FLYOUT_BREAKPOINT = 'm';
var euiFlyoutSlideInRight = exports.euiFlyoutSlideInRight = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  from {\n    opacity: 0;\n    transform: translateX(100%);\n  }\n  to {\n    opacity: 1;\n    transform: translateX(0%);\n  }\n"])));
var euiFlyoutSlideOutRight = exports.euiFlyoutSlideOutRight = (0, _react.keyframes)(_templateObject2 || (_templateObject2 = _taggedTemplateLiteral(["\n  from {\n    opacity: 1;\n    transform: translateX(0%);\n  }\n  to {\n    opacity: 0;\n    transform: translateX(100%);\n  }\n"])));
var euiFlyoutSlideInLeft = exports.euiFlyoutSlideInLeft = (0, _react.keyframes)(_templateObject3 || (_templateObject3 = _taggedTemplateLiteral(["\n  from {\n    opacity: 0;\n    transform: translateX(-100%);\n  }\n  to {\n    opacity: 1;\n    transform: translateX(0%);\n  }\n"])));
var euiFlyoutSlideOutLeft = exports.euiFlyoutSlideOutLeft = (0, _react.keyframes)(_templateObject4 || (_templateObject4 = _taggedTemplateLiteral(["\n  from {\n    opacity: 1;\n    transform: translateX(0);\n  }\n  to {\n    opacity: 0;\n    transform: translateX(-100%);\n  }\n"])));
var _ref = process.env.NODE_ENV === "production" ? {
  name: "yokctr-noAnimation",
  styles: "animation-duration:0s!important;label:noAnimation;"
} : {
  name: "yokctr-noAnimation",
  styles: "animation-duration:0s!important;label:noAnimation;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "rks1ev-overlay",
  styles: "&:has(.euiResizableButton){border-inline:none;};label:overlay;"
} : {
  name: "rks1ev-overlay",
  styles: "&:has(.euiResizableButton){border-inline:none;};label:overlay;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFlyoutStyles = exports.euiFlyoutStyles = function euiFlyoutStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiFlyout: /*#__PURE__*/(0, _react.css)("position:fixed;", (0, _global_styling.logicalCSS)('bottom', 0), " ", (0, _global_styling.logicalCSS)('top', 'var(--euiFixedHeadersOffset, 0)'), " ", (0, _global_styling.logicalCSS)('height', 'inherit'), " background:", euiTheme.colors.backgroundBasePlain, ";display:flex;flex-direction:column;align-items:stretch;&:focus{outline:none;}&.euiFlyout--hasChildBackground{background:", euiTheme.colors.backgroundBaseSubdued, ";}", maxedFlyoutWidth(euiThemeContext), ";;label:euiFlyout;"),
    // Flyout sizes
    // When a child flyout is stacked on top of the parent, the parent flyout size will match the child flyout size
    s: /*#__PURE__*/(0, _react.css)(composeFlyoutSizing(euiThemeContext, 's'), " &.euiFlyout--hasChild--stacked.euiFlyout--hasChild--m{", composeFlyoutSizing(euiThemeContext, 'm'), ";};label:s;"),
    m: /*#__PURE__*/(0, _react.css)(composeFlyoutSizing(euiThemeContext, 'm'), " &.euiFlyout--hasChild--stacked.euiFlyout--hasChild--s{", composeFlyoutSizing(euiThemeContext, 's'), ";};label:m;"),
    l: /*#__PURE__*/(0, _react.css)(composeFlyoutSizing(euiThemeContext, 'l'), ";;label:l;"),
    fill: /*#__PURE__*/(0, _react.css)(composeFlyoutSizing(euiThemeContext, 'fill'), ";;label:fill;"),
    noMaxWidth: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-width', 'none'), ";;label:noMaxWidth;"),
    // Side
    right: /*#__PURE__*/(0, _react.css)("clip-path:polygon(-50% 0, 100% 0, 100% 100%, -50% 100%);", (0, _global_styling.logicalCSS)('right', 0), "animation:", euiFlyoutSlideInRight, " 0s ", euiTheme.animation.resistance, " forwards;", _global_styling.euiCanAnimate, "{animation-duration:", euiTheme.animation.normal, ";}&.euiFlyout--hasChild{clip-path:none;};label:right;"),
    // Left-side flyouts should only be used for navigation
    left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('left', 0), " clip-path:polygon(0 0, 150% 0, 150% 100%, 0 100%);animation:", euiFlyoutSlideInLeft, " 0s ", euiTheme.animation.resistance, " forwards;", _global_styling.euiCanAnimate, "{animation-duration:", euiTheme.animation.normal, ";};label:left;"),
    // Type
    overlay: {
      overlay: _ref2,
      left: /*#__PURE__*/(0, _react.css)((0, _euiThemeCommon.euiShadowXLarge)(euiThemeContext, {
        borderAllInHighContrastMode: true,
        border: 'right'
      }), ";;label:left;"),
      right: /*#__PURE__*/(0, _react.css)((0, _euiThemeCommon.euiShadowXLarge)(euiThemeContext, {
        borderAllInHighContrastMode: true,
        border: 'left'
      }), ";;label:right;")
    },
    push: {
      push: /*#__PURE__*/(0, _react.css)("clip-path:none;z-index:", Number(euiTheme.levels.flyout) - 1, ";;label:push;"),
      right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-left', euiTheme.border.thick), ";;label:right;"),
      left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-right', euiTheme.border.thick), ";;label:left;"),
      noAnimation: _ref
    },
    // Padding
    paddingSizes: {
      none: /*#__PURE__*/(0, _react.css)(composeFlyoutPadding(euiThemeContext, 'none'), ";;label:none;"),
      s: /*#__PURE__*/(0, _react.css)(composeFlyoutPadding(euiThemeContext, 's'), ";;label:s;"),
      m: /*#__PURE__*/(0, _react.css)(composeFlyoutPadding(euiThemeContext, 'm'), ";;label:m;"),
      l: /*#__PURE__*/(0, _react.css)(composeFlyoutPadding(euiThemeContext, 'l'), ";;label:l;")
    }
  };
};
var maxedFlyoutWidth = exports.maxedFlyoutWidth = function maxedFlyoutWidth(euiThemeContext) {
  return "\n  ".concat((0, _global_styling.euiMaxBreakpoint)(euiThemeContext, FLYOUT_BREAKPOINT), " {\n    ").concat((0, _global_styling.logicalCSS)('max-width', '90vw !important'), "\n  }\n");
};
var composeFlyoutSizing = exports.composeFlyoutSizing = function composeFlyoutSizing(euiThemeContext, size) {
  var euiTheme = euiThemeContext.euiTheme;
  var formMaxWidth = (0, _form.euiFormMaxWidth)(euiThemeContext);

  // 1. Calculating the minimum width based on the screen takeover breakpoint
  var flyoutSizes = {
    s: {
      min: "".concat(Math.round(euiTheme.breakpoint.m * 0.5), "px"),
      // 1.
      width: '25vw',
      max: "".concat(Math.round(euiTheme.breakpoint.s * 0.7), "px")
    },
    m: {
      // Calculated for forms plus padding
      min: "".concat((0, _global_styling.mathWithUnits)(formMaxWidth, function (x) {
        return x + 24;
      })),
      width: '50vw',
      max: "".concat(euiTheme.breakpoint.m, "px")
    },
    l: {
      min: "".concat(Math.round(euiTheme.breakpoint.m * 0.9), "px"),
      // 1.
      width: '75vw',
      max: "".concat(euiTheme.breakpoint.l, "px")
    },
    // NOTE: These styles are for the flyout system in `stacked` layout mode.
    // In `side-by-side` mode, @flyout.component.tsx uses inline styles.
    fill: {
      min: '90vw',
      width: '90vw',
      max: '90vw'
    }
  };
  return "\n    ".concat((0, _global_styling.logicalCSS)('max-width', flyoutSizes[size].max), "\n\n    ").concat((0, _global_styling.euiMaxBreakpoint)(euiThemeContext, FLYOUT_BREAKPOINT), " {\n      ").concat((0, _global_styling.logicalCSS)('min-width', 0), "\n      ").concat((0, _global_styling.logicalCSS)('width', flyoutSizes[size].min), "\n    }\n    ").concat((0, _global_styling.euiMinBreakpoint)(euiThemeContext, FLYOUT_BREAKPOINT), " {\n      ").concat((0, _global_styling.logicalCSS)('min-width', flyoutSizes[size].min), "\n      ").concat((0, _global_styling.logicalCSS)('width', flyoutSizes[size].width), "\n    }\n  ");
};
var composeFlyoutPadding = function composeFlyoutPadding(euiThemeContext, paddingSize) {
  var euiTheme = euiThemeContext.euiTheme;
  var paddingModifierMap = {
    none: 0,
    s: euiTheme.size.s,
    m: euiTheme.size.base,
    l: euiTheme.size.l
  };

  // Footer padding
  var footerPaddingSizes = {
    none: 0,
    s: euiTheme.size.s,
    m: "".concat((0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 0.75;
    }), " ").concat(euiTheme.size.base, ";"),
    l: "".concat((0, _global_styling.mathWithUnits)(euiTheme.size.l, function (x) {
      return x / 1.5;
    }), " ").concat(euiTheme.size.l, ";")
  };
  return "\n    .euiFlyoutHeader {\n      ".concat((0, _global_styling.logicalCSS)('padding-horizontal', paddingModifierMap[paddingSize]), "\n      ").concat((0, _global_styling.logicalCSS)('padding-top', paddingModifierMap[paddingSize]), "\n    }\n\n    [class*='euiFlyoutHeader-hasBorder'] {\n      ").concat((0, _global_styling.logicalCSS)('padding-bottom', paddingModifierMap[paddingSize]), "\n    }\n\n    .euiFlyoutBody__overflowContent {\n      padding: ").concat(paddingModifierMap[paddingSize], ";\n    }\n\n    .euiFlyoutBody__banner .euiCallOut {\n      ").concat((0, _global_styling.logicalCSS)('padding-horizontal', paddingModifierMap[paddingSize]), "\n    }\n\n    .euiFlyoutFooter {\n      padding: ").concat(footerPaddingSizes[paddingSize], ";\n    }\n  ");
};

/**
 * Helper for `composeFlyoutInlineStyles`
 * Handles maxWidth prop overrides to ensure they take precedence over base CSS
 */
var composeMaxWidthOverrides = function composeMaxWidthOverrides(maxWidth, isFill) {
  if (typeof maxWidth === 'boolean') {
    return {};
  }
  var overrides = {
    maxWidth: maxWidth
  };

  // For fill size flyouts, we need to override min-width to allow dynamic sizing
  if (isFill) {
    overrides.minWidth = '0';

    // When maxWidth is provided for fill flyouts, we need to override the CSS rule
    // that sets min-inline-size: 90vw. We calculate min(maxWidth, 90vw) to ensure
    // the flyout respects both constraints and doesn't get stuck at 90vw minimum.
    if (maxWidth) {
      var maxWidthWithUnits = typeof maxWidth === 'number' ? "".concat(maxWidth, "px") : maxWidth;
      overrides.minWidth = "min(".concat(maxWidthWithUnits, ", 90vw)");
    }
  }
  return (0, _global_styling.logicalStyles)(overrides);
};

/**
 * Composes all inline styles for a flyout based on its configuration
 */
var composeFlyoutInlineStyles = exports.composeFlyoutInlineStyles = function composeFlyoutInlineStyles(size, layoutMode, siblingFlyoutId, siblingFlyoutWidth, maxWidth, zIndex) {
  // Handle custom width values (non-named sizes)
  var customWidthStyles = !(0, _const.isEuiFlyoutSizeNamed)(size) ? (0, _global_styling.logicalStyles)({
    width: size
  }) : {};
  var isFill = size === 'fill';

  // Handle dynamic width calculation for fill size in side-by-side mode
  var dynamicStyles = isFill && layoutMode === 'side-by-side' && siblingFlyoutId && siblingFlyoutWidth ? (0, _global_styling.logicalStyles)({
    width: "calc(90vw - ".concat(siblingFlyoutWidth, "px)"),
    minWidth: '0'
  }) : {};

  // For fill flyouts with maxWidth, we need to ensure the minWidth override is applied
  // to override the CSS rule that sets min-inline-size: 90vw
  var minWidthOverride = {};
  if (isFill && maxWidth) {
    if (layoutMode === 'side-by-side' && siblingFlyoutId && siblingFlyoutWidth && dynamicStyles.inlineSize) {
      // For fill flyouts with maxWidth and a sibling: min(maxWidth, calc(90vw - siblingWidth))
      var dynamicWidth = dynamicStyles.inlineSize;
      var maxWidthWithUnits = typeof maxWidth === 'number' ? "".concat(maxWidth, "px") : maxWidth;
      minWidthOverride = {
        minWidth: "min(".concat(maxWidthWithUnits, ", ").concat(dynamicWidth, ")")
      };
    } else {
      // For fill flyouts with maxWidth but no sibling: min(maxWidth, 90vw)
      var maxWidthOverrides = composeMaxWidthOverrides(maxWidth, isFill);
      minWidthOverride = {
        minWidth: maxWidthOverrides.minInlineSize
      };
    }
  }

  // Calculate the final maxWidth based on conditions
  var finalMaxWidth;
  if (maxWidth && isFill && layoutMode === 'side-by-side' && siblingFlyoutId && siblingFlyoutWidth && dynamicStyles.inlineSize) {
    // For fill flyouts with maxWidth and a sibling: min(maxWidth, calc(90vw - siblingWidth))
    var _dynamicWidth = dynamicStyles.inlineSize;
    var _maxWidthWithUnits = typeof maxWidth === 'number' ? "".concat(maxWidth, "px") : maxWidth;
    finalMaxWidth = "min(".concat(_maxWidthWithUnits, ", ").concat(_dynamicWidth, ")");
  } else if (maxWidth) {
    // For all other cases with maxWidth: use the original maxWidth value
    finalMaxWidth = typeof maxWidth === 'number' ? "".concat(maxWidth, "px") : maxWidth;
  }
  return (0, _global_styling.logicalStyles)(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, customWidthStyles), dynamicStyles), minWidthOverride), finalMaxWidth ? {
    maxWidth: finalMaxWidth
  } : {}), {}, {
    zIndex: zIndex
  }));
};