"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyoutResizeButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _services = require("../../services");
var _resizable_container = require("../resizable_container");
var _flyout_resize_button = require("./_flyout_resize_button.styles");
var _react2 = require("@emotion/react");
var _excluded = ["type", "side", "ownFocus", "isPushed"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiFlyoutResizeButton = exports.EuiFlyoutResizeButton = function EuiFlyoutResizeButton(_ref) {
  var type = _ref.type,
    side = _ref.side,
    ownFocus = _ref.ownFocus,
    isPushed = _ref.isPushed,
    resizableButtonProps = _objectWithoutProperties(_ref, _excluded);
  var hasOverlay = ownFocus && type === 'overlay';
  var styles = (0, _services.useEuiMemoizedStyles)(_flyout_resize_button.euiFlyoutResizeButtonStyles);
  var cssStyles = [styles.root, styles[type][side], !hasOverlay && styles.noOverlay.root, !hasOverlay && styles.noOverlay[side]];
  return (0, _react2.jsx)(_resizable_container.EuiResizableButton, _extends({
    isHorizontal: true,
    indicator: "border",
    css: cssStyles
  }, resizableButtonProps));
};