"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFlexGridStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "nq5j9u-baseline",
  styles: "align-items:baseline;label:baseline;"
} : {
  name: "nq5j9u-baseline",
  styles: "align-items:baseline;label:baseline;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "8391db-center",
  styles: "align-items:center;label:center;"
} : {
  name: "8391db-center",
  styles: "align-items:center;label:center;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "7uusvr-end",
  styles: "align-items:end;label:end;"
} : {
  name: "7uusvr-end",
  styles: "align-items:end;label:end;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "dve6he-start",
  styles: "align-items:start;label:start;"
} : {
  name: "dve6he-start",
  styles: "align-items:start;label:start;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref5 = process.env.NODE_ENV === "production" ? {
  name: "1uwc4oj-stretch",
  styles: "align-items:stretch;label:stretch;"
} : {
  name: "1uwc4oj-stretch",
  styles: "align-items:stretch;label:stretch;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref6 = process.env.NODE_ENV === "production" ? {
  name: "11m0lc1-4",
  styles: "grid-template-columns:repeat(4, 1fr);label:4;"
} : {
  name: "11m0lc1-4",
  styles: "grid-template-columns:repeat(4, 1fr);label:4;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref7 = process.env.NODE_ENV === "production" ? {
  name: "13nda58-3",
  styles: "grid-template-columns:repeat(3, 1fr);label:3;"
} : {
  name: "13nda58-3",
  styles: "grid-template-columns:repeat(3, 1fr);label:3;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref8 = process.env.NODE_ENV === "production" ? {
  name: "1yhdavu-2",
  styles: "grid-template-columns:repeat(2, 1fr);label:2;"
} : {
  name: "1yhdavu-2",
  styles: "grid-template-columns:repeat(2, 1fr);label:2;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref9 = process.env.NODE_ENV === "production" ? {
  name: "bjo3uw-1",
  styles: "grid-template-columns:repeat(1, 1fr);label:1;"
} : {
  name: "bjo3uw-1",
  styles: "grid-template-columns:repeat(1, 1fr);label:1;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref10 = process.env.NODE_ENV === "production" ? {
  name: "1t690q7-column",
  styles: "grid-auto-flow:column;label:column;"
} : {
  name: "1t690q7-column",
  styles: "grid-auto-flow:column;label:column;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref11 = process.env.NODE_ENV === "production" ? {
  name: "1uinx0j-euiFlexGrid",
  styles: "display:grid;label:euiFlexGrid;"
} : {
  name: "1uinx0j-euiFlexGrid",
  styles: "display:grid;label:euiFlexGrid;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFlexGridStyles = exports.euiFlexGridStyles = function euiFlexGridStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiFlexGrid: _ref11,
    responsive: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiMaxBreakpoint)(euiThemeContext, 'm'), "{grid-template-columns:repeat(1, 1fr);grid-auto-flow:row;};label:responsive;"),
    direction: {
      row: /*#__PURE__*/(0, _react.css)(";label:row;"),
      // Note: the only way to get column direction working with `display: grid`
      // the same way `display: flex` works is to manually set `grid-template-rows`,
      // calculated based on the number of children in the grid
      column: _ref10
    },
    columnCount: {
      '1': _ref9,
      '2': _ref8,
      '3': _ref7,
      '4': _ref6
    },
    gutterSizes: {
      none: /*#__PURE__*/(0, _react.css)(";label:none;"),
      s: /*#__PURE__*/(0, _react.css)("gap:", euiTheme.size.s, ";;label:s;"),
      m: /*#__PURE__*/(0, _react.css)("gap:", euiTheme.size.base, ";;label:m;"),
      l: /*#__PURE__*/(0, _react.css)("gap:", euiTheme.size.l, ";;label:l;"),
      xl: /*#__PURE__*/(0, _react.css)("gap:", euiTheme.size.xl, ";;label:xl;")
    },
    alignItems: {
      stretch: _ref5,
      start: _ref4,
      end: _ref3,
      center: _ref2,
      baseline: _ref
    }
  };
};