"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDatePickerRangeStyles = exports.euiDatePickerRangeInlineStyles = void 0;
var _react = require("@emotion/react");
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _global_styling = require("../../global_styling");
var _form = require("../form/form.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiDatePickerRangeStyles = exports.euiDatePickerRangeStyles = function euiDatePickerRangeStyles() {
  return {
    euiDatePickerRange: /*#__PURE__*/(0, _react.css)(".euiPopover,.react-datepicker__input-container,.euiDatePicker{", (0, _global_styling.logicalCSS)('height', '100%'), ";}.euiPopover{flex:1;}.euiPopover:last-child{", (0, _global_styling.logicalCSS)('border-top-right-radius', 'inherit'), " ", (0, _global_styling.logicalCSS)('border-bottom-right-radius', 'inherit'), " *{", (0, _global_styling.logicalCSS)('border-top-right-radius', 'inherit'), " ", (0, _global_styling.logicalCSS)('border-bottom-right-radius', 'inherit'), ";}};label:euiDatePickerRange;")
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "bicgs9-noShadow",
  styles: "background-color:transparent;label:noShadow;"
} : {
  name: "bicgs9-noShadow",
  styles: "background-color:transparent;label:noShadow;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiDatePickerRangeInlineStyles = exports.euiDatePickerRangeInlineStyles = function euiDatePickerRangeInlineStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;

  // Use a container query to stack date pickers vertically if the container is
  // not wide enough to fit both. We need a fn for this to render two width queries,
  // depending on whether time selection is being rendered or not
  var containerQuery = function containerQuery(datePickerWidth) {
    var delimiterWidth = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 16;
    return "\n    display: block;\n    container-type: inline-size;\n\n    .euiFormControlLayout__childrenWrapper {\n      /* Use static px widths for now, since render behavior comes from a third party library */\n      @container (max-width: ".concat(datePickerWidth * 2 + delimiterWidth, "px) {\n        /* Unset grid display */\n        display: block !important;\n\n        /* Center and point the default delimiter arrow downwards */\n        .euiFormControlLayoutDelimited__delimiter .euiIcon {\n          transform: rotate(90deg);\n          margin-inline: auto;\n        }\n      }\n    }");
  };
  return {
    euiDatePickerRangeInline: /*#__PURE__*/(0, _react.css)(".euiFormControlLayoutDelimited{", (0, _global_styling.logicalCSS)('height', 'auto'), " ", (0, _global_styling.logicalCSS)('width', 'fit-content'), " ", (0, _global_styling.logicalCSS)('max-width', '100%'), " border:none;padding:0;.euiFormControlLayout__childrenWrapper{display:grid;grid-template-columns:1fr auto 1fr;grid-template-rows:auto;align-items:stretch;background-color:transparent;}.euiFormControlLayoutIcons{justify-content:center;grid-column:1/span 3;", (0, _global_styling.logicalCSS)('height', 'auto'), " ", (0, _global_styling.logicalCSS)('padding-bottom', euiTheme.size.s), ";}&::after{display:none;}}.react-datepicker{position:relative;};label:euiDatePickerRangeInline;"),
    responsive: /*#__PURE__*/(0, _react.css)(containerQuery(268), ";;label:responsive;"),
    responsiveWithTimeSelect: /*#__PURE__*/(0, _react.css)(containerQuery(374), ";;label:responsiveWithTimeSelect;"),
    shadow: /*#__PURE__*/(0, _react.css)(".euiFormControlLayoutDelimited{", (0, _euiThemeCommon.euiShadowMedium)(euiThemeContext, {
      borderAllInHighContrastMode: true
    }), (0, _form.disableFormControlHoverStyles)(), " .euiFormControlLayout__childrenWrapper{box-shadow:none;", (0, _form.disableFormControlHoverStyles)(), ";}};label:shadow;"),
    // Applied directly to EuiFormControlLayout so we can check if `disabled`
    // and allow the disabled background-color to take precedence
    formLayout: {
      noShadow: _ref,
      shadow: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.colors.emptyShade, ";;label:shadow;")
    }
  };
};