"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiButtonDisplay = void 0;
exports.isButtonDisabled = isButtonDisabled;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react2 = require("@emotion/react");
var _services = require("../../../services");
var _href_validator = require("../../../services/security/href_validator");
var _useEuiDisabledElement = require("../../../services/hooks/useEuiDisabledElement");
var _button_display = require("./_button_display.styles");
var _button_display_content = require("./_button_display_content");
var _excluded = ["element", "type", "children", "iconType", "iconSide", "iconSize", "size", "isDisabled", "disabled", "hasAriaDisabled", "isLoading", "isSelected", "fullWidth", "minWidth", "contentProps", "textProps", "href", "target", "rel", "style"],
  _excluded2 = ["ref"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// @ts-ignore module doesn't export `createElement`
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var SIZES = ['xs', 's', 'm'];

/**
 * Extends EuiButtonDisplayContentProps which provides
 * `iconType`, `iconSide`, and `textProps`
 */

function isButtonDisabled(_ref) {
  var href = _ref.href,
    isDisabled = _ref.isDisabled,
    isLoading = _ref.isLoading;
  var isHrefValid = !href || (0, _href_validator.validateHref)(href);
  return isLoading || isDisabled || !isHrefValid;
}

/**
 * EuiButtonDisplay is an internal-only component used for displaying
 * any element as a button.
 */
var EuiButtonDisplay = exports.EuiButtonDisplay = /*#__PURE__*/(0, _react.forwardRef)(function (_ref2, ref) {
  var _ref2$element = _ref2.element,
    _element = _ref2$element === void 0 ? 'button' : _ref2$element,
    _ref2$type = _ref2.type,
    type = _ref2$type === void 0 ? 'button' : _ref2$type,
    children = _ref2.children,
    iconType = _ref2.iconType,
    _ref2$iconSide = _ref2.iconSide,
    iconSide = _ref2$iconSide === void 0 ? 'left' : _ref2$iconSide,
    iconSize = _ref2.iconSize,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? 'm' : _ref2$size,
    isDisabled = _ref2.isDisabled,
    disabled = _ref2.disabled,
    _ref2$hasAriaDisabled = _ref2.hasAriaDisabled,
    hasAriaDisabled = _ref2$hasAriaDisabled === void 0 ? false : _ref2$hasAriaDisabled,
    isLoading = _ref2.isLoading,
    isSelected = _ref2.isSelected,
    fullWidth = _ref2.fullWidth,
    minWidth = _ref2.minWidth,
    contentProps = _ref2.contentProps,
    textProps = _ref2.textProps,
    href = _ref2.href,
    target = _ref2.target,
    rel = _ref2.rel,
    style = _ref2.style,
    rest = _objectWithoutProperties(_ref2, _excluded);
  var buttonIsDisabled = isButtonDisabled({
    href: href,
    isDisabled: isDisabled || disabled,
    isLoading: isLoading
  });
  var _useEuiDisabledElemen = (0, _useEuiDisabledElement.useEuiDisabledElement)({
      isDisabled: buttonIsDisabled,
      hasAriaDisabled: hasAriaDisabled,
      onKeyDown: rest.onKeyDown
    }),
    disabledRef = _useEuiDisabledElemen.ref,
    disabledButtonProps = _objectWithoutProperties(_useEuiDisabledElemen, _excluded2);
  var setCombinedRef = (0, _services.useCombinedRefs)([disabledRef, ref]);
  var styles = (0, _services.useEuiMemoizedStyles)(_button_display.euiButtonDisplayStyles);
  var cssStyles = [styles.euiButtonDisplay, styles[size], fullWidth && styles.fullWidth, minWidth == null && [styles.defaultMinWidth.defaultMinWidth, styles.defaultMinWidth[size]], buttonIsDisabled && styles.isDisabled];
  var innerNode = (0, _react2.jsx)(_button_display_content.EuiButtonDisplayContent, _extends({
    isLoading: isLoading,
    isDisabled: buttonIsDisabled,
    iconType: iconType,
    iconSide: iconSide,
    iconSize: iconSize,
    textProps: textProps
  }, contentProps), children);
  var element = buttonIsDisabled ? 'button' : href ? 'a' : _element;
  var elementProps = {
    ref: setCombinedRef
  };
  var buttonProps = {};
  if (element === 'button') {
    buttonProps = _objectSpread({
      'aria-pressed': isSelected
    }, disabledButtonProps);
  }
  var relObj = {};
  if (href && !buttonIsDisabled) {
    relObj.href = href;
    relObj.rel = (0, _services.getSecureRelForTarget)({
      href: href,
      target: target,
      rel: rel
    });
    relObj.target = target;
  } else {
    relObj.type = type;
  }
  return (0, _react2.createElement)(element, _objectSpread(_objectSpread(_objectSpread(_objectSpread({
    css: cssStyles,
    style: minWidth ? _objectSpread(_objectSpread({}, style), {}, {
      minInlineSize: minWidth
    }) : style
  }, elementProps), relObj), rest), buttonProps), innerNode);
});
EuiButtonDisplay.propTypes = {
  href: _propTypes.default.string,
  onClick: _propTypes.default.func,
  element: _propTypes.default.oneOf(["a", "button", "span"]),
  children: _propTypes.default.node,
  size: _propTypes.default.any,
  /**
     * Applies the boolean state as the `aria-pressed` property to create a toggle button.
     * *Only use when the readable text does not change between states.*
     */
  /**
     * Applies the boolean state as the `aria-pressed` property to create a toggle button.
     * *Only use when the readable text does not change between states.*
     */
  isSelected: _propTypes.default.bool,
  /**
     * Extends the button to 100% width
     */
  /**
     * Extends the button to 100% width
     */
  fullWidth: _propTypes.default.bool,
  /**
     * Override the default minimum width
     */
  /**
     * Override the default minimum width
     */
  minWidth: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf([false])]),
  /**
     * Force disables the button and changes the icon to a loading spinner
     */
  /**
     * Force disables the button and changes the icon to a loading spinner
     */
  isLoading: _propTypes.default.bool,
  /**
     * Object of props passed to the <span/> wrapping the button's content
     */
  /**
     * Object of props passed to the <span/> wrapping the button's content
     */
  contentProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  style: _propTypes.default.any,
  type: _propTypes.default.any,
  /**
     * Controls the disabled behavior via the native `disabled` attribute.
     */
  isDisabled: _propTypes.default.bool,
  /**
     * NOTE: Beta feature, may be changed or removed in the future
     *
     * Changes the native `disabled` attribute to `aria-disabled` to preserve focusability.
     * This results in a semantically disabled button without the default browser handling of the disabled state.
     *
     * Use e.g. when a disabled button should have a tooltip.
     */
  hasAriaDisabled: _propTypes.default.bool,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  buttonRef: _propTypes.default.any
};
EuiButtonDisplay.displayName = 'EuiButtonDisplay';