"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiBreadcrumbCollapsed = exports.EuiBreadcrumb = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _breadcrumb_content = require("./_breadcrumb_content");
var _breadcrumb = require("./breadcrumb.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "type", "truncate"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiBreadcrumb = exports.EuiBreadcrumb = function EuiBreadcrumb(_ref) {
  var children = _ref.children,
    className = _ref.className,
    type = _ref.type,
    truncate = _ref.truncate,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiBreadcrumb', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_breadcrumb.euiBreadcrumbStyles);
  var cssStyles = [styles.euiBreadcrumb, styles[type], truncate && styles.isTruncated];
  return (0, _react2.jsx)("li", _extends({
    className: classes,
    css: cssStyles,
    "data-test-subj": "euiBreadcrumb"
  }, rest), children);
};
var EuiBreadcrumbCollapsed = exports.EuiBreadcrumbCollapsed = function EuiBreadcrumbCollapsed(_ref2) {
  var children = _ref2.children,
    isFirstBreadcrumb = _ref2.isFirstBreadcrumb,
    type = _ref2.type;
  var styles = (0, _services.useEuiMemoizedStyles)(_breadcrumb.euiBreadcrumbStyles);
  var cssStyles = [styles.isCollapsed];
  var ariaLabel = (0, _i18n.useEuiI18n)('euiBreadcrumb.collapsedBadge.ariaLabel', 'See collapsed breadcrumbs');
  return (0, _react2.jsx)(EuiBreadcrumb, {
    css: cssStyles,
    type: type
  }, (0, _react2.jsx)(_breadcrumb_content.EuiBreadcrumbContent, {
    popoverContent: children,
    text: (0, _react2.jsx)("span", {
      "aria-label": ariaLabel
    }, "\u2026"),
    title: ariaLabel,
    truncate: false,
    isFirstBreadcrumb: isFirstBreadcrumb,
    type: type
  }));
};