"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildLineStyles = buildLineStyles;
const color_library_wrappers_1 = require("../../../../../common/color_library_wrappers");
const common_1 = require("../../../../../utils/common");
function buildLineStyles(seriesColor, themeLineStyle, highlightState) {
    const isDimmed = highlightState === 'dimmed';
    const isFocused = highlightState === 'focused';
    const strokeColor = isDimmed && 'stroke' in themeLineStyle.dimmed ? themeLineStyle.dimmed.stroke : seriesColor;
    const opacity = isDimmed && 'opacity' in themeLineStyle.dimmed
        ? themeLineStyle.dimmed.opacity * themeLineStyle.opacity
        : themeLineStyle.opacity;
    const width = isDimmed && 'strokeWidth' in themeLineStyle.dimmed
        ? themeLineStyle.dimmed.strokeWidth
        : isFocused && 'strokeWidth' in themeLineStyle.focused
            ? themeLineStyle.focused.strokeWidth
            : themeLineStyle.strokeWidth;
    const color = (0, color_library_wrappers_1.overrideOpacity)((0, color_library_wrappers_1.colorToRgba)((0, common_1.getColorFromVariant)(strokeColor, themeLineStyle.stroke)), (currentColorOpacity) => currentColorOpacity * opacity);
    return {
        color,
        width,
        dash: themeLineStyle.dash,
    };
}
//# sourceMappingURL=line.js.map