"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricText = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importDefault(require("react"));
const secondary_metric_1 = require("./secondary_metric");
const text_measurements_1 = require("./text_measurements");
const titles_1 = require("./titles");
const common_1 = require("../../../../utils/common");
const specs_1 = require("../../specs");
const GRID_SPAN_THREE = '1 / span 3';
const gridRows = {
    top: { value: '1', titles: '2', body: '3', extra: '4' },
    bottom: { value: '4', titles: '1', body: '2', extra: '3' },
};
const gridSingleColumn = { value: '1', titles: '1', body: '1', extra: '1' };
const gridColumnsValuePostitionTop = {
    left: { value: '2 / span 2', titles: GRID_SPAN_THREE, body: GRID_SPAN_THREE, extra: GRID_SPAN_THREE },
    right: { value: '1 / span 2', titles: GRID_SPAN_THREE, body: GRID_SPAN_THREE, extra: GRID_SPAN_THREE },
};
const gridColumnsValuePositionBottom = {
    left: { value: GRID_SPAN_THREE, titles: '2 / span 2', body: GRID_SPAN_THREE, extra: GRID_SPAN_THREE },
    right: { value: GRID_SPAN_THREE, titles: '1 / span 2', body: GRID_SPAN_THREE, extra: GRID_SPAN_THREE },
};
const gridColumns = {
    top: gridColumnsValuePostitionTop,
    bottom: gridColumnsValuePositionBottom,
};
const getGridTemplateColumnsWithIcon = (iconSize) => {
    const iconSizeWithPadding = `${iconSize + text_measurements_1.PADDING}px`;
    return `${iconSizeWithPadding} minmax(0, 1fr) ${iconSizeWithPadding}`;
};
const gridTemplateRows = {
    bottom: `min-content auto min-content min-content`,
    top: `min-content min-content auto min-content`,
};
const MetricText = ({ id, datum, style, onElementClick, progressBarSize, textDimensions, colors, defaultBadgeBorderColor, }) => {
    const { heightBasedSizes: sizes, hasProgressBar, progressBarDirection, visibility, textParts } = textDimensions;
    const { extra, body } = datum;
    const containerClassName = (0, classnames_1.default)('echMetricText', {
        [`echMetricText--${progressBarSize}`]: hasProgressBar,
        'echMetricText--vertical': progressBarDirection === common_1.LayoutDirection.Vertical,
        'echMetricText--horizontal': progressBarDirection === common_1.LayoutDirection.Horizontal,
    });
    const { valuePosition, iconAlign } = style;
    const isIconVisible = !!datum.icon;
    const gridTemplateColumns = isIconVisible ? getGridTemplateColumnsWithIcon(sizes.iconSize) : undefined;
    const currentGridTemplateRows = gridTemplateRows[valuePosition];
    const iconGridStyles = isIconVisible ? { gridRow: '1', gridColumn: iconAlign === 'left' ? '1' : '3' } : {};
    const currentGridRows = gridRows[valuePosition];
    let currentGridColumns = isIconVisible ? gridColumns[valuePosition][iconAlign] : gridSingleColumn;
    if (isIconVisible && valuePosition === 'top' && style.valueTextAlign === 'center') {
        currentGridColumns = { ...currentGridColumns, value: '2' };
    }
    if (isIconVisible && valuePosition === 'bottom' && style.titlesTextAlign === 'center') {
        currentGridColumns = { ...currentGridColumns, titles: '2' };
    }
    let extraElement = null;
    if ((0, specs_1.isSecondaryMetricProps)(extra)) {
        const { style: extraStyle = {}, ...secondaryMetricProps } = extra;
        const { badgeBorderColor: rawBorder = { mode: 'none' }, ...restSecondaryMetricProps } = secondaryMetricProps;
        const resolvedBadgeBorderColor = rawBorder.mode === 'none' ? undefined : rawBorder.mode === 'auto' ? defaultBadgeBorderColor : rawBorder.color;
        extraElement = (react_1.default.createElement(secondary_metric_1.SecondaryMetric, { style: { ...extraStyle, fontSize: sizes.extraFontSize, color: colors.extra }, ...restSecondaryMetricProps, badgeBorderColor: resolvedBadgeBorderColor }));
    }
    else if (react_1.default.isValidElement(extra) || typeof extra === 'function') {
        extraElement = (react_1.default.createElement("p", { className: "echMetricText__extra", style: { fontSize: sizes.extraFontSize } }, (0, common_1.renderWithProps)(extra, { fontSize: sizes.extraFontSize, color: colors.extra })));
    }
    return (react_1.default.createElement("div", { className: containerClassName, style: { color: colors.highContrast, gridTemplateColumns, gridTemplateRows: currentGridTemplateRows } },
        react_1.default.createElement(titles_1.TitlesBlock, { metricId: id, title: datum.title, subtitle: datum.subtitle, sizes: sizes, visibility: visibility, textAlign: style.titlesTextAlign, titleWeight: style.titleWeight, isIconVisible: isIconVisible, titlesRow: currentGridRows.titles, titlesColumn: currentGridColumns.titles, subtitleColor: colors.subtitle, onElementClick: onElementClick }),
        datum.icon && (react_1.default.createElement("div", { className: (0, classnames_1.default)('echMetricText__icon', `echMetricText__icon--${style.iconAlign}`), style: { ...iconGridStyles } }, (0, common_1.renderWithProps)(datum.icon, {
            width: sizes.iconSize,
            height: sizes.iconSize,
            color: colors.highContrast,
        }))),
        react_1.default.createElement("div", { className: "echMetricText__gap", style: { gridRow: currentGridRows.body, gridColumn: currentGridColumns.body } }, body && react_1.default.createElement("div", { className: "echMetricText__body" }, body)),
        react_1.default.createElement("div", { className: (0, classnames_1.default)('echMetricText__extraBlock', `echMetricText__extraBlock--${style.extraTextAlign}`), style: {
                gridRow: currentGridRows.extra,
                gridColumn: currentGridColumns.extra,
                color: colors.extra,
            } }, visibility.extra && extraElement),
        react_1.default.createElement("div", { className: (0, classnames_1.default)('echMetricText__valueBlock', `echMetricText__valueBlock--${style.valueTextAlign}`), style: { gridRow: currentGridRows.value, gridColumn: currentGridColumns.value } },
            react_1.default.createElement("p", { className: "echMetricText__value", style: {
                    fontSize: sizes.valueFontSize,
                    textOverflow: (0, specs_1.isMetricWNumber)(datum) ? undefined : 'ellipsis',
                    color: datum.valueColor,
                }, title: textParts.map(({ text }) => text).join('') }, textParts.map(({ emphasis, text }, i) => {
                return emphasis === 'small' ? (react_1.default.createElement("span", { key: `${text}${i}`, className: "echMetricText__part", style: { fontSize: sizes.valuePartFontSize } }, text)) : (text);
            })),
            datum.valueIcon && (react_1.default.createElement("p", { className: "echMetricText__valueIcon", style: {
                    fontSize: sizes.valueFontSize,
                    color: datum.valueColor ?? colors.highContrast,
                    marginRight: style.valueTextAlign === 'center' ? -(sizes.valuePartFontSize + text_measurements_1.PADDING) : undefined,
                } }, (0, common_1.renderWithProps)(datum.valueIcon, {
                width: sizes.valuePartFontSize,
                height: sizes.valuePartFontSize,
                color: datum.valueColor ?? colors.highContrast,
                verticalAlign: 'middle',
            }))))));
};
exports.MetricText = MetricText;
//# sourceMappingURL=text.js.map