"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.core = void 0;
var _inversify = require("inversify");
var _capabilities = require("./capabilities");
var _http = require("./http");
var _saved_objects = require("./saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const core = exports.core = new _inversify.ContainerModule(options => {
  (0, _capabilities.loadCapabilites)(options);
  (0, _http.loadHttp)(options);
  (0, _saved_objects.loadSavedObjects)(options);
});