"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = exports.DataStreamsConfig = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const dataStreamsSchema = _configSchema.schema.object({
  migrations: _configSchema.schema.object({
    skip: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
});
const config = exports.config = {
  path: 'dataStreams',
  schema: dataStreamsSchema
};
class DataStreamsConfig {
  constructor(rawConfig) {
    (0, _defineProperty2.default)(this, "migrations", void 0);
    this.migrations = rawConfig.migrations || {};
  }
}
exports.DataStreamsConfig = DataStreamsConfig;