"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLayoutStyles = void 0;
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const cssProp = (0, _react.css)`
  height: 100vh;
  width: 100vw;
  min-height: 100%;
  min-width: 100%;

  @media screen {
    // do not restrict height when printing
    overflow: hidden;
  }

  display: grid;

  grid-template-areas:
    'banner banner banner'
    'header header header'
    'navigation application sidebar'
    'footer footer footer';
`;

// TODO: clintandrewhall - Handle smaller screens using `useEuiBreakpoints`.
const useLayoutStyles = layoutState => {
  const {
    navigationWidth,
    sidebarWidth,
    bannerHeight,
    headerHeight,
    footerHeight
  } = layoutState;
  const style = {
    gridTemplateColumns: `
      ${navigationWidth}px
      1fr
      ${sidebarWidth}px
    `,
    gridTemplateRows: `
      ${bannerHeight}px
      ${headerHeight}px
      1fr
      ${footerHeight}px
    `
  };
  return {
    css: cssProp,
    style
  };
};
exports.useLayoutStyles = useLayoutStyles;