"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateStepState = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateStepState = currentStep => {
  return {
    configure: currentStep === 'start' || currentStep === 'deployment' ? 'incomplete' : currentStep === 'configure' ? 'current' : 'complete',
    deployment: currentStep === 'deployment' ? 'current' : currentStep === 'finish' || currentStep === 'configure' ? 'complete' : 'incomplete',
    finish: currentStep === 'finish' ? 'current' : 'incomplete',
    start: currentStep === 'start' ? 'current' : 'complete'
  };
};
exports.generateStepState = generateStepState;