"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeploymentLogic = void 0;
var _kea = require("kea");
var _generate_connector_config_api_logic = require("../../api/connector/generate_connector_config_api_logic");
var _api = require("../../../common/types/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeploymentLogic = exports.DeploymentLogic = (0, _kea.kea)({
  connect: {
    actions: [_generate_connector_config_api_logic.GenerateConfigApiLogic, ['makeRequest as generateConfiguration', 'apiSuccess as generateConfigurationSuccess']],
    values: [_generate_connector_config_api_logic.GenerateConfigApiLogic, ['status as generateConfigurationStatus', 'data as generatedData', 'error as generateConfigurationError']]
  },
  selectors: {
    isGenerateLoading: [selectors => [selectors.generateConfigurationStatus], status => status === _api.Status.LOADING]
  }
});