"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorDetailRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-react-plugin/public");
var _routes = require("../routes");
var _index_name_logic = require("../search_index/index_name_logic");
var _index_view_logic = require("../search_index/index_view_logic");
var _connector_detail = require("./connector_detail");
var _connector_view_logic = require("./connector_view_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connector_detail/connector_detail_router.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorDetailRouter = () => {
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  (0, _react.useEffect)(() => {
    const unmountName = _index_name_logic.IndexNameLogic.mount();
    const unmountView = (0, _connector_view_logic.ConnectorViewLogic)({
      http
    }).mount();
    const unmountIndexView = (0, _index_view_logic.IndexViewLogic)({
      http
    }).mount();
    return () => {
      unmountName();
      unmountView();
      unmountIndexView();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const {
    setIndexName
  } = (0, _kea.useActions)(_index_name_logic.IndexNameLogic);
  const {
    connector
  } = (0, _kea.useValues)((0, _connector_view_logic.ConnectorViewLogic)({
    http
  }));
  const {
    startFetchIndexPoll,
    stopFetchIndexPoll,
    resetFetchIndexApi
  } = (0, _kea.useActions)((0, _index_view_logic.IndexViewLogic)({
    http
  }));
  const indexName = (connector === null || connector === void 0 ? void 0 : connector.index_name) || '';
  (0, _react.useEffect)(() => {
    setIndexName(indexName);
    if (indexName) {
      startFetchIndexPoll(indexName);
    } else {
      stopFetchIndexPoll();
      resetFetchIndexApi();
    }
  }, [indexName, resetFetchIndexApi, setIndexName, startFetchIndexPoll, stopFetchIndexPoll]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.CONNECTOR_DETAIL_PATH,
    exact: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_detail.ConnectorDetail, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.CONNECTOR_DETAIL_TAB_PATH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_detail.ConnectorDetail, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  })));
};
exports.ConnectorDetailRouter = ConnectorDetailRouter;