"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorFullTypes = getConnectorFullTypes;
exports.getConnectorTypes = getConnectorTypes;
var _connectors = require("@kbn/search-connectors/constants/connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// used on server and in browser before plugin start when we don't have docLinks yet
function getConnectorTypes(staticAssets) {
  return _connectors.CONNECTOR_DEFINITIONS.map(connector => ({
    ...connector,
    iconPath: connector.iconPath ? staticAssets.getPluginAssetHref(`icons/${connector.iconPath}`) : 'logoElasticsearch'
  }));
}

// used in browser after pluginStart, when docLinks has been populated
function getConnectorFullTypes(staticAssets) {
  const CONNECTORS_DICT = (0, _connectors.getConnectorsDict)();
  const CONNECTORS = _connectors.CONNECTOR_DEFINITIONS.map(connector => ({
    ...connector,
    ...(connector.serviceType && CONNECTORS_DICT[connector.serviceType] ? CONNECTORS_DICT[connector.serviceType] : CONNECTORS_DICT.custom)
  }));
  return CONNECTORS.map(connector => ({
    ...connector,
    iconPath: connector.iconPath ? staticAssets.getPluginAssetHref(`icons/${connector.iconPath}`) : 'logoElasticsearch'
  }));
}