"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = exports.initialValue = void 0;
var _lodash = require("lodash");
var _embeddable_console = require("../../types/embeddable_console");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const initialValue = exports.initialValue = {
  consoleHasBeenOpened: false,
  view: _embeddable_console.EmbeddableConsoleView.Closed
};
const reducer = (state, action) => {
  var _action$payload;
  switch (action.type) {
    case 'open':
      const newView = (_action$payload = action.payload) !== null && _action$payload !== void 0 && _action$payload.alternateView ? _embeddable_console.EmbeddableConsoleView.Alternate : _embeddable_console.EmbeddableConsoleView.Console;
      if (state.view !== newView) {
        var _action$payload2;
        const draft = (0, _lodash.cloneDeep)(state);
        draft.consoleHasBeenOpened = true;
        draft.view = newView;
        draft.loadFromContent = (_action$payload2 = action.payload) === null || _action$payload2 === void 0 ? void 0 : _action$payload2.content;
        return draft;
      }
      break;
    case 'close':
      if (state.view !== _embeddable_console.EmbeddableConsoleView.Closed) {
        const draft = (0, _lodash.cloneDeep)(state);
        draft.view = _embeddable_console.EmbeddableConsoleView.Closed;
        draft.loadFromContent = undefined;
        return draft;
      }
      break;
  }
  return state;
};
exports.reducer = reducer;