"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResizerButtonStyles = exports.consoleEditorPanelStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const consoleEditorPanelStyles = exports.consoleEditorPanelStyles = (0, _react.css)`
  display: flex;
  flex: 1 1 auto;
  position: absolute;
  left: 0;
  bottom: 0;
  right: 0;
  overflow: hidden;
`;
const useResizerButtonStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react.css)`
    // Give the aria selection border priority when the divider is selected on IE11 and Chrome
    z-index: ${euiTheme.levels.header};
    background-color: ${euiTheme.colors.lightestShade};
    // The margin ensures that the resizer doesn't cover the top border of the selected request
    // in the output panel, when in vertical layout
    margin-bottom: 1px;
    // The margin ensures that the resizer doesn't cover the first Monaco editor's ruler
    margin-inline: 0;
  `;
};
exports.useResizerButtonStyles = useResizerButtonStyles;