"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutorSubActionPushParamsSchemaITSM = exports.ExecutorParamsSchemaITSM = void 0;
var _zod = require("@kbn/zod");
var _servicenow = require("../../servicenow");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ExecutorSubActionPushParamsSchemaITSM = exports.ExecutorSubActionPushParamsSchemaITSM = _zod.z.object({
  incident: _zod.z.object({
    ..._servicenow.CommonAttributes,
    severity: _zod.z.string().nullable().default(null),
    urgency: _zod.z.string().nullable().default(null),
    impact: _zod.z.string().nullable().default(null)
  }).strict(),
  comments: _servicenow.CommentsSchema
}).strict();
const ExecutorParamsSchemaITSM = exports.ExecutorParamsSchemaITSM = _zod.z.discriminatedUnion('subAction', [_zod.z.object({
  subAction: _zod.z.literal('getFields'),
  subActionParams: _servicenow.ExecutorSubActionCommonFieldsParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('getIncident'),
  subActionParams: _servicenow.ExecutorSubActionGetIncidentParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('handshake'),
  subActionParams: _servicenow.ExecutorSubActionHandshakeParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('pushToService'),
  subActionParams: ExecutorSubActionPushParamsSchemaITSM
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('getChoices'),
  subActionParams: _servicenow.ExecutorSubActionGetChoicesParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('closeIncident'),
  subActionParams: _servicenow.ExecutorSubActionCloseIncidentParamsSchema
}).strict()]);