"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.incidentSchemaObjectProperties = exports.ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceSecretConfiguration = exports.ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfiguration = exports.ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionHandshakeParamsSchema = exports.ExecutorSubActionGetIssuesParamsSchema = exports.ExecutorSubActionGetIssueTypesParamsSchema = exports.ExecutorSubActionGetIssueParamsSchema = exports.ExecutorSubActionGetIncidentParamsSchema = exports.ExecutorSubActionGetFieldsByIssueTypeParamsSchema = exports.ExecutorSubActionGetCapabilitiesParamsSchema = exports.ExecutorSubActionCommonFieldsParamsSchema = exports.ExecutorParamsSchema = void 0;
var _zod = require("@kbn/zod");
var _utils = require("../../common/utils");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ExternalIncidentServiceConfiguration = exports.ExternalIncidentServiceConfiguration = {
  apiUrl: _zod.z.string(),
  projectKey: _zod.z.string()
};
const ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfigurationSchema = _zod.z.object(ExternalIncidentServiceConfiguration).strict();
const ExternalIncidentServiceSecretConfiguration = exports.ExternalIncidentServiceSecretConfiguration = {
  email: _zod.z.string(),
  apiToken: _zod.z.string()
};
const ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceSecretConfigurationSchema = _zod.z.object(ExternalIncidentServiceSecretConfiguration).strict();
const validateOtherFieldsKeys = (key, ctx) => {
  (0, _utils.validateKeysAllowed)({
    key,
    ctx,
    disallowList: incidentSchemaObjectProperties,
    fieldName: 'otherFields'
  });
};
const incidentSchemaObject = {
  summary: _zod.z.string(),
  description: _zod.z.string().nullable().default(null),
  externalId: _zod.z.string().nullable().default(null),
  issueType: _zod.z.string().nullable().default(null),
  priority: _zod.z.string().nullable().default(null),
  labels: _zod.z.array(_zod.z.string().refine(val => !val.match(/\s/g), val => ({
    message: `The label ${val} cannot contain spaces`
  }))).nullable().default(null),
  parent: _zod.z.string().nullable().default(null),
  otherFields: (0, _utils.Coerced)(_zod.z.record(_zod.z.string().superRefine((value, ctx) => {
    validateOtherFieldsKeys(value, ctx);
  }), _zod.z.any()).superRefine((val, ctx) => (0, _utils.validateRecordMaxKeys)({
    record: val,
    ctx,
    maxNumberOfFields: _constants.MAX_OTHER_FIELDS_LENGTH,
    fieldName: 'otherFields'
  })).nullable().default(null))
};
const incidentSchemaObjectProperties = exports.incidentSchemaObjectProperties = Object.keys(incidentSchemaObject);
const ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionPushParamsSchema = _zod.z.object({
  incident: _zod.z.object(incidentSchemaObject).strict(),
  comments: _zod.z.array(_zod.z.object({
    comment: _zod.z.string(),
    commentId: _zod.z.string()
  }).strict()).nullable().default(null)
});
const ExecutorSubActionGetIncidentParamsSchema = exports.ExecutorSubActionGetIncidentParamsSchema = _zod.z.object({
  externalId: _zod.z.string()
}).strict();

// Reserved for future implementation
const ExecutorSubActionCommonFieldsParamsSchema = exports.ExecutorSubActionCommonFieldsParamsSchema = _zod.z.object({}).strict();
const ExecutorSubActionHandshakeParamsSchema = exports.ExecutorSubActionHandshakeParamsSchema = _zod.z.object({}).strict();
const ExecutorSubActionGetCapabilitiesParamsSchema = exports.ExecutorSubActionGetCapabilitiesParamsSchema = _zod.z.object({}).strict();
const ExecutorSubActionGetIssueTypesParamsSchema = exports.ExecutorSubActionGetIssueTypesParamsSchema = _zod.z.object({}).strict();
const ExecutorSubActionGetFieldsByIssueTypeParamsSchema = exports.ExecutorSubActionGetFieldsByIssueTypeParamsSchema = _zod.z.object({
  id: _zod.z.string()
}).strict();
const ExecutorSubActionGetIssuesParamsSchema = exports.ExecutorSubActionGetIssuesParamsSchema = _zod.z.object({
  title: _zod.z.string()
}).strict();
const ExecutorSubActionGetIssueParamsSchema = exports.ExecutorSubActionGetIssueParamsSchema = _zod.z.object({
  id: _zod.z.string()
}).strict();
const ExecutorParamsSchema = exports.ExecutorParamsSchema = _zod.z.discriminatedUnion('subAction', [_zod.z.object({
  subAction: _zod.z.literal('getFields'),
  subActionParams: ExecutorSubActionCommonFieldsParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('getIncident'),
  subActionParams: ExecutorSubActionGetIncidentParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('handshake'),
  subActionParams: ExecutorSubActionHandshakeParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('pushToService'),
  subActionParams: ExecutorSubActionPushParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('issueTypes'),
  subActionParams: ExecutorSubActionGetIssueTypesParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('fieldsByIssueType'),
  subActionParams: ExecutorSubActionGetFieldsByIssueTypeParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('issues'),
  subActionParams: ExecutorSubActionGetIssuesParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal('issue'),
  subActionParams: ExecutorSubActionGetIssueParamsSchema
}).strict()]);