"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorRangeAutoDetectButton = ColorRangeAutoDetectButton;
exports.ColorRangeDeleteButton = ColorRangeDeleteButton;
exports.ColorRangeEditButton = ColorRangeEditButton;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _visualizationUtils = require("@kbn/visualization-utils");
var _utils = require("./utils");
var _color_ranges_context = require("./color_ranges_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-coloring/src/shared_components/coloring/color_ranges/color_ranges_item_buttons.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const switchContinuity = (isLast, continuity) => {
  switch (continuity) {
    case 'none':
      return isLast ? 'above' : 'below';
    case 'above':
      return isLast ? 'none' : 'all';
    case 'below':
      return isLast ? 'all' : 'none';
    case 'all':
      return isLast ? 'below' : 'above';
  }
};
function ColorRangeDeleteButton({
  index,
  dispatch
}) {
  const {
    dataBounds,
    palettes
  } = (0, _react.useContext)(_color_ranges_context.ColorRangesContext);
  const onExecuteAction = (0, _react.useCallback)(() => {
    dispatch({
      type: 'deleteColorRange',
      payload: {
        index,
        dataBounds,
        palettes
      }
    });
  }, [dispatch, index, dataBounds, palettes]);
  const title = _i18n.i18n.translate('coloring.dynamicColoring.customPalette.deleteButtonAriaLabel', {
    defaultMessage: 'Delete'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    "aria-label": title,
    title: title,
    onClick: onExecuteAction,
    "data-test-subj": `lnsPalettePanel_dynamicColoring_removeColorRange_${index}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  });
}
function ColorRangeEditButton({
  index,
  continuity,
  dispatch,
  accessor
}) {
  const {
    dataBounds,
    palettes,
    disableSwitchingContinuity
  } = (0, _react.useContext)(_color_ranges_context.ColorRangesContext);
  const isLast = (0, _utils.isLastItem)(accessor);
  const onExecuteAction = (0, _react.useCallback)(() => {
    const newContinuity = switchContinuity(isLast, continuity);
    dispatch({
      type: 'updateContinuity',
      payload: {
        isLast,
        continuity: newContinuity,
        dataBounds,
        palettes
      }
    });
  }, [isLast, dispatch, continuity, dataBounds, palettes]);
  let tooltipContent = isLast ? _i18n.i18n.translate('coloring.dynamicColoring.customPalette.setCustomMinValue', {
    defaultMessage: `Set custom maximum value`
  }) : _i18n.i18n.translate('coloring.dynamicColoring.customPalette.setCustomMaxValue', {
    defaultMessage: `Set custom minimum value`
  });
  if (disableSwitchingContinuity) {
    tooltipContent = _i18n.i18n.translate('coloring.dynamicColoring.customPalette.disallowedEditMinMaxValues', {
      defaultMessage: `You cannot set custom value for current configuration`
    });
  }
  return /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
    tooltipContent: tooltipContent,
    condition: true,
    position: "top",
    delay: "regular",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "pencil",
    "aria-label": tooltipContent,
    disabled: disableSwitchingContinuity,
    onClick: onExecuteAction,
    "data-test-subj": `lnsPalettePanel_dynamicColoring_editValue_${index}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }));
}
function ColorRangeAutoDetectButton({
  continuity,
  dispatch,
  accessor,
  tooltipContent,
  iconFactory
}) {
  const {
    dataBounds,
    palettes
  } = (0, _react.useContext)(_color_ranges_context.ColorRangesContext);
  const isLast = (0, _utils.isLastItem)(accessor);
  const onExecuteAction = (0, _react.useCallback)(() => {
    const newContinuity = switchContinuity(isLast, continuity);
    dispatch({
      type: 'updateContinuity',
      payload: {
        isLast,
        continuity: newContinuity,
        dataBounds,
        palettes
      }
    });
  }, [continuity, dataBounds, dispatch, isLast, palettes]);
  return /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
    tooltipContent: tooltipContent,
    condition: true,
    position: "top",
    delay: "regular",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: iconFactory,
    "aria-label": tooltipContent,
    onClick: onExecuteAction,
    "data-test-subj": `lnsPalettePanel_dynamicColoring_autoDetect_${isLast ? 'maximum' : 'minimum'}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }));
}