"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoVulnerabilitiesStates = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _use_csp_setup_status_api = require("@kbn/cloud-security-posture/src/hooks/use_csp_setup_status_api");
var _reactRouterDom = require("react-router-dom");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _empty_states_illustration_container = require("./empty_states_illustration_container");
var _constants = require("../../common/constants");
var _full_size_centered_page = require("./full_size_centered_page");
var _cloud_posture_page = require("./cloud_posture_page");
var _test_subjects = require("./test_subjects");
var _use_csp_integration_link = require("../common/navigation/use_csp_integration_link");
var _use_navigate_to_cis_integration_policies = require("../common/navigation/use_navigate_to_cis_integration_policies");
var _clouds = _interopRequireDefault(require("../assets/illustrations/clouds.svg"));
var _constants2 = require("../common/navigation/constants");
var _vulnerability_vendor_dark = _interopRequireDefault(require("../assets/illustrations/vulnerability_vendor_dark.svg"));
var _vulnerability_vendor_bright = _interopRequireDefault(require("../assets/illustrations/vulnerability_vendor_bright.svg"));
var _use_add_integrations_route = require("../common/api/use_add_integrations_route");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/no_vulnerabilities_states.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const REFETCH_INTERVAL_MS = 20000;
const ScanningVulnerabilitiesEmptyPrompt = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": _test_subjects.NO_VULNERABILITIES_STATUS_TEST_SUBJ.SCANNING_VULNERABILITIES,
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoSecurity",
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.scanningVulnerabilitiesEmptyPrompt.indexingButtonTitle",
    defaultMessage: "Scanning your environment",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.scanningVulnerabilitiesEmptyPrompt.indexingDescription",
    defaultMessage: "Results will appear here as soon as they are available.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  })),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 3
  }
});
const CnvmIntegrationNotInstalledEmptyPrompt = ({
  vulnMgmtIntegrationLink
}) => {
  const location = (0, _reactRouterDom.useLocation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const addIntegrationRouteLink = (0, _use_add_integrations_route.useAddIntegrationRoute)('vulnerability_workflow');
  const is3PSupportedPage = location.pathname.includes(_cloudSecurityPosture.findingsNavigation.vulnerabilities.path);
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    css: {
      padding: euiTheme.size.l
    },
    "data-test-subj": _test_subjects.NO_VULNERABILITIES_STATUS_TEST_SUBJ.NOT_INSTALLED,
    icon: /*#__PURE__*/_react.default.createElement(_empty_states_illustration_container.EmptyStatesIllustrationContainer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: _clouds.default,
      alt: "clouds",
      role: "presentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 15
      }
    })),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilties.intergationNoInstalledEmptyPrompt.promptTitle",
      defaultMessage: "Elastic\u2019s Cloud Native {lineBreak} Vulnerability Management",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 102,
            columnNumber: 30
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 15
      }
    })),
    layout: "vertical",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilties.intergationNoInstalledEmptyPrompt.promptDescription",
      defaultMessage: " Detect and remediate potential vulnerabilities {lineBreak} in your cloud assets, with our Cloud Native {lineBreak} Vulnerability Management (CNVM) integration. {lineBreak} {learnMore}",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 116,
            columnNumber: 30
          }
        }),
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _constants2.cspIntegrationDocsNavigation.cnvm.overviewPath,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 118,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.vulnerabilties.intergationNoInstalledEmptyPrompt.learnMoreButtonTitle",
          defaultMessage: "Learn more",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 119,
            columnNumber: 23
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 15
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: vulnMgmtIntegrationLink,
      isDisabled: !vulnMgmtIntegrationLink,
      "data-test-subj": _test_subjects.CNVM_NOT_INSTALLED_ACTION_SUBJ,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilties.intergationNoInstalledEmptyPrompt.addVulMngtIntegrationButtonTitle",
      defaultMessage: "Add CNVM Integration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 19
      }
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  })), is3PSupportedPage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    css: {
      padding: euiTheme.size.l
    },
    "data-test-subj": _test_subjects.THIRD_PARTY_INTEGRATIONS_NO_VULNERABILITIES_FINDINGS_PROMPT,
    icon: /*#__PURE__*/_react.default.createElement(_empty_states_illustration_container.EmptyStatesIllustrationContainer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: isDarkMode ? _vulnerability_vendor_dark.default : _vulnerability_vendor_bright.default,
      alt: isDarkMode ? 'vulnerabilityVendorDarkSVG' : 'vulnerabilityVendorBrightSVG',
      role: "presentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 17
      }
    })),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.3pIntegrationsNoVulnFindingsPrompt.promptTitle",
      defaultMessage: "Already using a vulnerability{lineBreak} management solution?",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 169,
            columnNumber: 40
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 17
      }
    })),
    layout: "vertical",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.3pIntegrationsNoVulnFindingsPrompt.promptDescription",
      defaultMessage: "Ingest vulnerability data to help you analyze,{lineBreak} hunt, and investigate threats by {lineBreak} providing contextual insights across your infrastructure.",
      values: {
        lineBreak: /*#__PURE__*/_react.default.createElement("br", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 180,
            columnNumber: 40
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 17
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: addIntegrationRouteLink,
      isDisabled: !addIntegrationRouteLink,
      "data-test-subj": _test_subjects.THIRD_PARTY_NO_VULNERABILITIES_FINDINGS_PROMPT_INTEGRATION_BUTTON,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.3pIntegrationsNoVulnFindingsPrompt.addIntegrationButtonTitle",
      defaultMessage: "Add Integration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 21
      }
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  })));
};
const CnvmIndexTimeout = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": _test_subjects.NO_VULNERABILITIES_STATUS_TEST_SUBJ.INDEX_TIMEOUT,
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoSecurity",
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.indexTimeout.indexTimeoutTitle",
    defaultMessage: "Findings Delayed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.indexTimeout.indexTimeoutDescription",
    defaultMessage: "Scanning workloads is taking longer than expected. Please check {docs}",
    values: {
      docs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://ela.st/cnvm-faq",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 231,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.noVulnerabilitiesStates.indexTimeout.indexTimeoutDocLink",
        defaultMessage: "CNVM FAQ",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 232,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 9
    }
  })),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 212,
    columnNumber: 3
  }
});
const Unprivileged = ({
  unprivilegedIndices
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": _test_subjects.NO_VULNERABILITIES_STATUS_TEST_SUBJ.UNPRIVILEGED,
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoSecurity",
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 11
    }
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.unprivileged.unprivilegedTitle",
    defaultMessage: "Privileges required",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 9
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.noVulnerabilitiesStates.unprivileged.unprivilegedDescription",
    defaultMessage: "To view cloud posture data, you must update privileges. For more information, contact your Kibana administrator.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 9
    }
  })),
  footer: /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    css: (0, _react2.css)`
          text-align: initial;
        `,
    children: _i18n.i18n.translate('xpack.csp.noVulnerabilitiesStates.unprivileged.unprivilegedFooterMarkdown', {
      defaultMessage: 'Required Elasticsearch index privilege `read` for the following indices:'
    }) + unprivilegedIndices.map(idx => `\n- \`${idx}\``),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 7
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 246,
    columnNumber: 3
  }
});
const AgentNotDeployedEmptyPrompt = ({
  postureType
}) => {
  const integrationPoliciesLink = (0, _use_navigate_to_cis_integration_policies.useCISIntegrationPoliciesLink)({
    postureType
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": _test_subjects.NO_VULNERABILITIES_STATUS_TEST_SUBJ.NOT_DEPLOYED,
    color: "plain",
    iconType: "fleetApp",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 295,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.noVulnerabilitiesStates.noAgentsDeployed.noAgentsDeployedTitle",
      defaultMessage: "No Agents Installed",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 296,
        columnNumber: 11
      }
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.noVulnerabilitiesStates.noAgentsDeployed.noAgentsDeployedDescription",
      defaultMessage: "In order to begin detecting vulnerabilities, you'll need to deploy elastic-agent into the cloud account or Kubernetes cluster you want to monitor.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 11
      }
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      href: integrationPoliciesLink,
      isDisabled: !integrationPoliciesLink,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 311,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.noVulnerabilitiesStates.noAgentsDeployed.noAgentsDeployedButtonTitle",
      defaultMessage: "Install Agent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 312,
        columnNumber: 11
      }
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 5
    }
  });
};

/**
 * This component will return the render states based on cloud posture setup status API
 * since 'not-installed' is being checked globally by CloudPosturePage and 'indexed' is the pass condition, those states won't be handled here
 * */
const NoVulnerabilitiesStates = () => {
  var _getSetupStatus$data, _getSetupStatus$data$, _getSetupStatus$data2;
  const getSetupStatus = (0, _use_csp_setup_status_api.useCspSetupStatusApi)({
    refetchInterval: REFETCH_INTERVAL_MS
  });
  const vulnMgmtIntegrationLink = (0, _use_csp_integration_link.useCspIntegrationLink)(_constants.VULN_MGMT_POLICY_TEMPLATE);
  const status = (_getSetupStatus$data = getSetupStatus.data) === null || _getSetupStatus$data === void 0 ? void 0 : (_getSetupStatus$data$ = _getSetupStatus$data.vuln_mgmt) === null || _getSetupStatus$data$ === void 0 ? void 0 : _getSetupStatus$data$.status;
  const indicesStatus = (_getSetupStatus$data2 = getSetupStatus.data) === null || _getSetupStatus$data2 === void 0 ? void 0 : _getSetupStatus$data2.indicesDetails;
  const unprivilegedIndices = indicesStatus && indicesStatus.filter(idxDetails => idxDetails.status === 'unprivileged').map(idxDetails => idxDetails.index).sort((a, b) => a.localeCompare(b));
  const render = () => {
    if (status === 'indexing' || status === 'waiting_for_results') return /*#__PURE__*/_react.default.createElement(ScanningVulnerabilitiesEmptyPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 343,
        columnNumber: 14
      }
    }); // integration installed, but no agents added// agent added, index timeout has passed
    if (status === 'index-timeout') return /*#__PURE__*/_react.default.createElement(CnvmIndexTimeout, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 344,
        columnNumber: 44
      }
    });
    if (status === 'not-installed') return /*#__PURE__*/_react.default.createElement(CnvmIntegrationNotInstalledEmptyPrompt, {
      vulnMgmtIntegrationLink: vulnMgmtIntegrationLink,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 347,
        columnNumber: 9
      }
    });
    if (status === 'not-deployed') return /*#__PURE__*/_react.default.createElement(AgentNotDeployedEmptyPrompt, {
      postureType: _constants.VULN_MGMT_POLICY_TEMPLATE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 350,
        columnNumber: 14
      }
    });
    if (status === 'unprivileged') return /*#__PURE__*/_react.default.createElement(Unprivileged, {
      unprivilegedIndices: unprivilegedIndices || [],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 352,
        columnNumber: 14
      }
    }); // user has no privileges for our indices
  };
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
    query: getSetupStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_full_size_centered_page.FullSizeCenteredPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 7
    }
  }, render()));
};
exports.NoVulnerabilitiesStates = NoVulnerabilitiesStates;