"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePersistedQuery = void 0;
var _react = require("react");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePersistedQuery = getter => {
  const {
    data: {
      query: {
        filterManager,
        queryString
      }
    }
  } = (0, _use_kibana.useKibana)().services;
  return (0, _react.useCallback)(() => getter({
    filters: filterManager.getAppFilters(),
    query: queryString.getQuery()
  }), [getter, filterManager, queryString]);
};
exports.usePersistedQuery = usePersistedQuery;