"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchDetectionRulesAlertsStatus = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../../common/constants");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchDetectionRulesAlertsStatus = tags => {
  const {
    http
  } = (0, _public.useKibana)().services;
  if (!http) {
    throw new Error('Kibana http service is not available');
  }
  return (0, _reactQuery.useQuery)({
    queryKey: [_constants2.DETECTION_ENGINE_ALERTS_KEY, tags],
    queryFn: () => http.get(_constants.GET_DETECTION_RULE_ALERTS_STATUS_PATH, {
      version: _constants.DETECTION_RULE_ALERTS_STATUS_API_CURRENT_VERSION,
      query: {
        tags
      }
    }),
    // Disabling retry to prevent stuck on loading state when the request fails due to permissions
    retry: false
  });
};
exports.useFetchDetectionRulesAlertsStatus = useFetchDetectionRulesAlertsStatus;