"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CspRouter = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@kbn/react-query");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _constants = require("../common/navigation/constants");
var _security_solution_context = require("./security_solution_context");
var pages = _interopRequireWildcard(require("../pages"));
var _csp_route = require("./csp_route");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/application/csp_router.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const queryClient = new _reactQuery.QueryClient({
  defaultOptions: {
    queries: {
      refetchOnWindowFocus: false
    }
  }
});

/** Props for the cloud security posture router component */

const CspRouter = ({
  securitySolutionContext
}) => {
  const routerElement = /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_csp_route.CspRoute, (0, _extends2.default)({}, _constants.cloudPosturePages.findings, {
    component: pages.Findings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_csp_route.CspRoute, (0, _extends2.default)({}, _constants.cloudPosturePages.dashboard, {
    component: pages.ComplianceDashboard,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_csp_route.CspRoute, (0, _extends2.default)({}, _constants.cloudPosturePages.vulnerability_dashboard, {
    component: pages.VulnerabilityDashboard,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_csp_route.CspRoute, (0, _extends2.default)({}, _constants.cloudPosturePages.benchmarks, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_csp_route.CspRoute, (0, _extends2.default)({}, _cloudSecurityPosture.benchmarksNavigation.rules, {
    component: pages.Rules,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_csp_route.CspRoute, (0, _extends2.default)({}, _constants.cloudPosturePages.benchmarks, {
    component: pages.Benchmarks,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: _constants.cloudPosturePages.dashboard.path,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }))));
  if (securitySolutionContext) {
    return /*#__PURE__*/_react.default.createElement(_security_solution_context.SecuritySolutionContext.Provider, {
      value: securitySolutionContext,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 7
      }
    }, routerElement);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, routerElement);
};

// Using a default export for usage with `React.lazy`
// eslint-disable-next-line import/no-default-export
exports.default = exports.CspRouter = CspRouter;