"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCSPRole = void 0;
exports.createCloudDefendPackagePolicy = createCloudDefendPackagePolicy;
exports.createPackagePolicy = createPackagePolicy;
exports.deleteUser = exports.deleteRole = exports.createUser = void 0;
var _coreHttpCommon = require("@kbn/core-http-common");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createPackagePolicy(supertest, agentPolicyId, policyTemplate, input, deployment, posture, packageName = 'cloud_security_posture-1', roleAuthc, internalRequestHeader) {
  const version = _constants.CLOUD_SECURITY_PLUGIN_VERSION;
  const title = 'Security Posture Management';
  const streams = [{
    enabled: true,
    data_stream: {
      type: 'logs',
      dataset: 'cloud_security_posture.vulnerabilities'
    }
  }];
  const inputTemplate = {
    enabled: true,
    type: input,
    policy_template: policyTemplate
  };
  const inputs = posture === 'vuln_mgmt' ? {
    ...inputTemplate,
    streams
  } : {
    ...inputTemplate
  };
  const {
    body: postPackageResponse
  } = roleAuthc && internalRequestHeader ? await supertest.post(`/api/fleet/package_policies`).set(_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER, '2023-10-31').set(internalRequestHeader).set(roleAuthc.apiKeyHeader).send({
    force: true,
    name: packageName,
    description: '',
    namespace: 'default',
    policy_id: agentPolicyId,
    enabled: true,
    inputs: [inputs],
    package: {
      name: 'cloud_security_posture',
      title,
      version
    },
    vars: {
      deployment: {
        value: deployment,
        type: 'text'
      },
      posture: {
        value: posture,
        type: 'text'
      }
    }
  }).expect(200) : await supertest.post(`/api/fleet/package_policies`).set(_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER, '2023-10-31').set('kbn-xsrf', 'xxxx').send({
    force: true,
    name: packageName,
    description: '',
    namespace: 'default',
    policy_id: agentPolicyId,
    enabled: true,
    inputs: [inputs],
    package: {
      name: 'cloud_security_posture',
      title,
      version
    },
    vars: {
      deployment: {
        value: deployment,
        type: 'text'
      },
      posture: {
        value: posture,
        type: 'text'
      }
    }
  }).expect(200);
  return postPackageResponse.item;
}
async function createCloudDefendPackagePolicy(supertest, agentPolicyId, roleAuthc, internalRequestHeader) {
  const version = '1.2.5';
  const installationPayload = {
    policy_id: agentPolicyId,
    package: {
      name: 'cloud_defend',
      version
    },
    name: 'cloud_defend-1',
    description: '',
    namespace: 'default',
    inputs: {
      'cloud_defend-cloud_defend/control': {
        enabled: true,
        vars: {
          configuration: 'process:\n  selectors:\n    - name: allProcesses\n      operation: [fork, exec]\n  responses:\n    - match: [allProcesses]\n      actions: [log]\nfile:\n  selectors:\n    - name: executableChanges\n      operation: [createExecutable, modifyExecutable]\n  responses:\n    - match: [executableChanges]\n      actions: [alert]\n'
        },
        streams: {
          'cloud_defend.alerts': {
            enabled: true
          },
          'cloud_defend.file': {
            enabled: true
          },
          'cloud_defend.heartbeat': {
            enabled: true,
            vars: {
              period: '30m'
            }
          },
          'cloud_defend.metrics': {
            enabled: true,
            vars: {
              period: '24h'
            }
          },
          'cloud_defend.process': {
            enabled: true
          }
        }
      }
    },
    force: true
  };
  const {
    body: postPackageResponse
  } = roleAuthc && internalRequestHeader ? await supertest.post(`/api/fleet/package_policies`).set(_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER, '2023-10-31').set(internalRequestHeader).set(roleAuthc.apiKeyHeader).send(installationPayload).expect(200) : await supertest.post(`/api/fleet/package_policies`).set(_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER, '2023-10-31').set('kbn-xsrf', 'xxxx').send(installationPayload).expect(200);
  return postPackageResponse.item;
}
const createUser = async (security, userName, roleName) => {
  await security.user.create(userName, {
    password: 'changeme',
    roles: [roleName],
    full_name: 'a reporting user'
  });
};
exports.createUser = createUser;
const createCSPRole = async (security, roleName, indicesName) => {
  await security.role.create(roleName, {
    kibana: [{
      feature: {
        siemV2: ['read'],
        fleetv2: ['all'],
        fleet: ['read']
      },
      spaces: ['*']
    }],
    ...(indicesName && indicesName.length > 0 ? {
      elasticsearch: {
        indices: [{
          names: indicesName,
          privileges: ['read']
        }]
      }
    } : {})
  });
};
exports.createCSPRole = createCSPRole;
const deleteRole = async (security, roleName) => {
  await security.role.delete(roleName);
};
exports.deleteRole = deleteRole;
const deleteUser = async (security, userName) => {
  await security.user.delete(userName);
};
exports.deleteUser = deleteUser;